package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 施工派工工单
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_work_order")
@ApiModel(value="WorkOrder", description="派工单实体类")
public class WorkOrder extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 派工单编号
     */
    @ApiModelProperty(value = "派工单编号",example = "PG002JXSRYG202403226123")
	@TableField("work_order_num")
    private String workOrderNum;

    /**
     * 制单人
     */
    @ApiModelProperty(value = "制单人",example = "admin")
	@TableField("preparer")
    private String preparer;

    /**
     * 制单日期
     */
    @ApiModelProperty(value = "制单日期",example = "2024-03-22")
    @JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("issue_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date issueDate;

    /**
     * 计划开工日期
     */
    @ApiModelProperty(value = "计划开工日期",example = "2025-03-22")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
	@TableField("planned_start_date")
    private Date plannedStartDate;

    /**
     * 计划完工日期
     */
    @ApiModelProperty(value = "计划完工日期",example = "2025-03-22")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
	@TableField("planned_end_date")
    private Date plannedEndDate;

    /**
     * 区域公司id
     */
    @ApiModelProperty(value = "区域公司id",example = "1702215275253886977")
	@TableField("region_company_id")
    private Long regionCompanyId;

    /**
     * 区域公司名称
     */
    @ApiModelProperty(value = "区域公司名称",example = "余干县赣德新能源科技有限公司")
	@TableField("region_company_name")
    private String regionCompanyName;

    /**
     * 区域公司orgcode
     */
    @ApiModelProperty(value = "区域公司orgcode",example = "86*354*344*385*446")
	@TableField("region_code")
    private String regionCode;


    /**
     * 区域公司省市区
     */
    @ApiModelProperty(value = "区域公司省市区",example = "江西省,上饶市,余干县")
    @TableField("region_address")
    private String regionAddress;


    /**
     * 工程负责人
     */
    @ApiModelProperty(value = "工程负责人",example = "admin")
	@TableField("project_region_manager")
    private String projectRegionManager;

    /**
     * 工程负责人电话
     */
    @ApiModelProperty(value = "工程负责人电话",example = "133222244122")
	@TableField("project_region_manager_phone")
    private String projectRegionManagerPhone;

    /**
     * 施工负责人
     */
    @ApiModelProperty(value = "施工负责人",example = "admin")
	@TableField("construction_region_manager")
    private String constructionRegionManager;

    /**
     * 施工负责人电话
     */
    @ApiModelProperty(value = "施工负责人电话",example = "133222244122")
	@TableField("construction_region_manager_phone")
    private String constructionRegionManagerPhone;

    /**
     * 派工单状态
     */
    @ApiModelProperty(value = "派工单状态",example = "已完工")
	@TableField("work_order_status")
    private String workOrderStatus;



    @ApiModelProperty(value = "平台经销商单位id",example = "1706869086106972161")
    @TableField("amos_dealer_id")
    private Long amosDealerId;
    @ApiModelProperty(value = "平台经销商单位名称",example = "四川锦绣天地建筑工程有限公司南昌分公司")
    @TableField("amos_dealer_name")
    private String amosDealerName;
    @ApiModelProperty(value = "平台经销商单位orgcode",example = "86*355*443*472")
    @TableField("amos_dealer_org_code")
    private String amosDealerOrgCode;


    @ApiModelProperty(value = "工程负责人userId",example = "213213")
    @TableField("project_region_manager_user_id")
    private String projectRegionManagerUserId;

    @ApiModelProperty(value = "工程注册人userId",example = "213213")
    @TableField("construction_region_manager_user_id")
    private String constructionRegionManagerUserId;




    @ApiModelProperty(value = "农户信息")
    @TableField(exist = false)
    List<PeasantHousehold> peasantHouseholdId;

    @ApiModelProperty(value = "施工电站数",example = "12")
    @TableField(exist = false)
    int peasantHouseholdNum;//施工电站数

    @ApiModelProperty(value = "已施工电站数",example = "10")
    @TableField(exist = false)
    int  peasantHouseholdSgNum;//已施工电站数
    /**
     * 经销商单位
     * */
    @ApiModelProperty(value = "经销商单位",example = "1706869086106972161")
    @TableField(exist = false)
    private Long developerId;
    @ApiModelProperty(value = "页码",example = "1")
    @TableField(exist = false)
    int current;
    @ApiModelProperty(value = "页数大小",example = "20")
    @TableField(exist = false)
    int size;
    @ApiModelProperty(value = "电站名称",example = "admin")
    @TableField(exist = false)
    private String ownersName;

    @ApiModelProperty(value = "路由地址Id",example = "17068690861069734112")
    @TableField(exist = false)
    private String routhPathId;
}
