package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordDTO;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordExportDTO;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordQueryDTO;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfIcbcRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * (hygf_icbc_record)数据Mapper
 *
 * @author yangyang
 * @description
 * @since 2024-07-18 11:40:46
 */
public interface HygfIcbcRecordMapper extends BaseMapper<HygfIcbcRecord> {

    @UserEmpower (field = {"ph.regional_companies_code"}, dealerField = {"ph.developer_code", "ph.regional_companies_code", "ph.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    Integer listObjectCount(@Param ("param") HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO);

    @UserEmpower (field = {"ph.regional_companies_code"}, dealerField = {"ph.developer_code", "ph.regional_companies_code", "ph.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    List<HygfIcbcRecordDTO> listObject(@Param ("param") HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO);

    @UserEmpower (field = {"ph.regional_companies_code"}, dealerField = {"ph.developer_code", "ph.regional_companies_code", "ph.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    List<HygfIcbcRecordDTO> pageList(@Param ("param") HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO);

    @UserEmpower (field = {"ph.regional_companies_code"}, dealerField = {"ph.developer_code", "ph.regional_companies_code", "ph.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    List<HygfIcbcRecordExportDTO> exportTotal(String developerCode, String regionalCompaniesCode, String province, String city, String district);

    @UserEmpower (field = {"ph.regional_companies_code"}, dealerField = {"ph.developer_code", "ph.regional_companies_code", "ph.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    List<HygfIcbcRecordExportDTO> paymentAmountExport(@Param ("param") HygfIcbcRecordQueryDTO hygfIcbcRecordQueryDTO);
}
