package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.hygf.api.entity.HistoryPeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.util.CommonResponseNewUtil;
import com.yeejoin.amos.component.robot.BadRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HistoryPeasantHouseholdServiceImpl;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.HistoryPeasantHouseholdDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 存量合同电站
 *
 * @author system_generator
 * @date 2024-10-18
 */
@RestController
@Api(tags = "存量合同电站Api")
@RequestMapping(value = "/history-peasant-household")
public class HistoryPeasantHouseholdController extends BaseController {

    @Autowired
    HistoryPeasantHouseholdServiceImpl historyPeasantHouseholdServiceImpl;

    /**
     * 新增存量合同电站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增存量合同电站", notes = "新增存量合同电站")
	public ResponseModel<HistoryPeasantHouseholdDto> save(@RequestBody HistoryPeasantHouseholdDto model) {
	    model = historyPeasantHouseholdServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新存量合同电站", notes = "根据sequenceNbr更新存量合同电站")
	public ResponseModel<HistoryPeasantHouseholdDto> updateBySequenceNbrHistoryPeasantHousehold(@RequestBody HistoryPeasantHouseholdDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);

	    return ResponseHelper.buildResponse(historyPeasantHouseholdServiceImpl.updateStation(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除存量合同电站", notes = "根据sequenceNbr删除存量合同电站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(historyPeasantHouseholdServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个存量合同电站",  notes = "根据sequenceNbr查询单个存量合同电站")
	public ResponseModel<HistoryPeasantHouseholdDto> selectOne(@PathVariable Long sequenceNbr) {
		HistoryPeasantHouseholdDto dto = historyPeasantHouseholdServiceImpl.getBaseMapper().selectDataInfo(sequenceNbr);

		dto.setFileUrl(JSONArray.parseArray(dto.getFiles()));

	    return ResponseHelper.buildResponse(dto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "存量合同电站分页查询",  notes = "存量合同电站分页查询")
	public ResponseModel<Page<HistoryPeasantHouseholdDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam(value = "ownersName",required = false) String ownersName , @RequestParam(value = "status",required = false) String status, @RequestParam(value = "province",required = false) String province, @RequestParam(value = "ids",required = false) String ids) {
	    Page<HistoryPeasantHouseholdDto> page = new Page<HistoryPeasantHouseholdDto>();
	    page.setCurrent(current);
	    page.setSize(size);
		List<String> strings = new ArrayList<>();
	    if (StringUtils.isNotEmpty(ids)){
			strings= Arrays.asList(ids.split(","));
		}
	    return ResponseHelper.buildResponse(historyPeasantHouseholdServiceImpl.queryForHistoryPeasantHouseholdPage(page,strings,ownersName,province,status));
	}



	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getByIds")
	@ApiOperation(httpMethod = "GET",value = "存量合同电站分页查询",  notes = "存量合同电站分页查询")
	public ResponseModel<List<HistoryPeasantHouseholdDto>> getByIds( @RequestParam(value = "ids",required = false) String ids) {
		Page<HistoryPeasantHouseholdDto> page = new Page<HistoryPeasantHouseholdDto>();
		page.setCurrent(1);
		page.setSize(Integer.MAX_VALUE);
		List<String> strings = new ArrayList<>();
		if (StringUtils.isNotEmpty(ids)){
			strings= Arrays.asList(ids.split(","));
		}
		Page<HistoryPeasantHouseholdDto> historyPeasantHouseholdDtoPage = historyPeasantHouseholdServiceImpl.queryForHistoryPeasantHouseholdPage(page, strings, null, null, null);
		return ResponseHelper.buildResponse(historyPeasantHouseholdDtoPage.getRecords());
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "存量合同电站列表全部数据查询",   notes = "存量合同电站列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HistoryPeasantHouseholdDto>> selectForList() {
	    return ResponseHelper.buildResponse(historyPeasantHouseholdServiceImpl.queryForHistoryPeasantHouseholdList());
	}


	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "存量合同电站模板下载",   notes = "存量合同电站模板下载")
	@GetMapping(value = "/downTemplate")
	public void downTemplate(HttpServletResponse response) {

		ExcelUtil.createTemplate(response,"存量合同电站模板","存量合同电站",null,HistoryPeasantHouseholdDto.class,null,false);
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "存量合同电站下载",   notes = "存量合同电站下载")
	@GetMapping(value = "/export")
	public void downTemplate(HttpServletResponse response,@RequestParam(value = "ids",required = false) List<String> ids) {

		historyPeasantHouseholdServiceImpl.exportData(response,ids);
	}

	/**
	 * 存量合同电站上传
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "存量合同电站上传",   notes = "存量合同电站上传")
	@PostMapping(value = "/uploadData")
	@Transactional
	public ResponseModel upload(MultipartFile file) throws Exception {

		historyPeasantHouseholdServiceImpl.uploadData(file);

		return CommonResponseNewUtil.success();
	}

}
