package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.MaintenanceFileServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.MaintenanceFileDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 运维人员文件
 *
 * @author system_generator
 * @date 2024-03-11
 */
@RestController
@Api(tags = "运维人员文件Api")
@RequestMapping(value = "/maintenance-file")
public class MaintenanceFileController extends BaseController {

    @Autowired
    MaintenanceFileServiceImpl maintenanceFileServiceImpl;

    /**
     * 新增运维人员文件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增运维人员文件", notes = "新增运维人员文件")
	public ResponseModel<MaintenanceFileDto> save(@RequestBody MaintenanceFileDto model) {
	    model = maintenanceFileServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新运维人员文件", notes = "根据sequenceNbr更新运维人员文件")
	public ResponseModel<MaintenanceFileDto> updateBySequenceNbrMaintenanceFile(@RequestBody MaintenanceFileDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(maintenanceFileServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除运维人员文件", notes = "根据sequenceNbr删除运维人员文件")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(maintenanceFileServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个运维人员文件",  notes = "根据sequenceNbr查询单个运维人员文件")
	public ResponseModel<MaintenanceFileDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(maintenanceFileServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "运维人员文件分页查询",  notes = "运维人员文件分页查询")
	public ResponseModel<Page<MaintenanceFileDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<MaintenanceFileDto> page = new Page<MaintenanceFileDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(maintenanceFileServiceImpl.queryForMaintenanceFilePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "运维人员文件列表全部数据查询",   notes = "运维人员文件列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<MaintenanceFileDto>> selectForList() {
	    return ResponseHelper.buildResponse(maintenanceFileServiceImpl.queryForMaintenanceFileList());
	}
}
