package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.RectificationOrderAuditingServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.RectificationOrderAuditingDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 施工完工审核表
 *
 * @author system_generator
 * @date 2024-08-13
 */
@RestController
@Api(tags = "施工完工审核表Api")
@RequestMapping(value = "/rectification-order-auditing")
public class RectificationOrderAuditingController extends BaseController {

    @Autowired
    RectificationOrderAuditingServiceImpl rectificationOrderAuditingServiceImpl;

    /**
     * 新增施工完工审核表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增施工完工审核表", notes = "新增施工完工审核表")
	public ResponseModel<RectificationOrderAuditingDto> save(@RequestBody RectificationOrderAuditingDto model) {
	    model = rectificationOrderAuditingServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新施工完工审核表", notes = "根据sequenceNbr更新施工完工审核表")
	public ResponseModel<RectificationOrderAuditingDto> updateBySequenceNbrRectificationOrderAuditing(@RequestBody RectificationOrderAuditingDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(rectificationOrderAuditingServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除施工完工审核表", notes = "根据sequenceNbr删除施工完工审核表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(rectificationOrderAuditingServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工完工审核表",  notes = "根据sequenceNbr查询单个施工完工审核表")
	public ResponseModel<RectificationOrderAuditingDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(rectificationOrderAuditingServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "施工完工审核表分页查询",  notes = "施工完工审核表分页查询")
	public ResponseModel<Page<RectificationOrderAuditingDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<RectificationOrderAuditingDto> page = new Page<RectificationOrderAuditingDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(rectificationOrderAuditingServiceImpl.queryForRectificationOrderAuditingPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "施工完工审核表列表全部数据查询",   notes = "施工完工审核表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<RectificationOrderAuditingDto>> selectForList() {
	    return ResponseHelper.buildResponse(rectificationOrderAuditingServiceImpl.queryForRectificationOrderAuditingList());
	}
}
