package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RectificationOrderEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingRectificationOrderDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfRectificationOrder;
import com.yeejoin.amos.boot.module.hygf.api.mapper.HygfRectificationOrderMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IHygfRectificationOrderService;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfRectificationOrderDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 审核单服务实现类
 *
 * @author system_generator
 * @date 2024-08-12
 */
@Service
public class HygfRectificationOrderServiceImpl extends BaseService<HygfRectificationOrderDto,HygfRectificationOrder,HygfRectificationOrderMapper> implements IHygfRectificationOrderService {
    /**
     * 分页查询
     */
    public Page<HygfRectificationOrder> queryForHygfRectificationOrderPage(int current, int size, List<String> rectificationSource, String peasantHouseholeId,List<String> status) {
//        PageHelper.startPage(current, size);
//        List<HygfRectificationOrder> list = this.getBaseMapper().selectOrderPage(rectificationSource,peasantHouseholeId);
//        PageInfo<HygfRectificationOrder> infos = new PageInfo<>(list);
//        Page<HygfRectificationOrder> page = new Page<>();
//        page.setRecords(list);
//        page.setSize(infos.getSize());
//        page.setCurrent(infos.getPageNum());
//        page.setTotal(infos.getTotal());
        // 创建 LambdaQueryWrapper 并添加查询条件
        LambdaQueryWrapper<HygfRectificationOrder> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(HygfRectificationOrder::getPeasantHouseholeId, peasantHouseholeId);
        if (rectificationSource != null && !rectificationSource.isEmpty()) {
            wrapper.in(HygfRectificationOrder::getRectificationSource, rectificationSource);
        }
        if (status != null && !status.isEmpty()) {
            wrapper.in(HygfRectificationOrder::getRectificationStatus, status);
        }

        // 创建 Page 对象并设置分页参数
        Page<HygfRectificationOrder> page = new Page<>(current, size);
        // 使用 service 的 page 方法执行分页查询
        this.page(page, wrapper);
        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<HygfRectificationOrderDto> queryForHygfRectificationOrderList()   {
        return this.queryForList("" , false);
    }

    public List<HygfRectificationOrder> selectForListBySource(String peasantHouseholeId, String sourceType) {
        //目前希望此接口公用 通过传递的枚举值来确定查询数据的范围
        LambdaQueryWrapper<HygfRectificationOrder> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(HygfRectificationOrder::getPeasantHouseholeId,peasantHouseholeId);
        wrapper.in(HygfRectificationOrder::getRectificationSource, Arrays.asList(RectificationOrderEnum.getNodeByName(sourceType).getCode().split(",")));
        wrapper.orderByDesc(BaseEntity::getRecDate);
        List<HygfRectificationOrder> hygfRectificationOrders = this.getBaseMapper().selectList(wrapper);
        for (HygfRectificationOrder hygfRectificationOrder : hygfRectificationOrders) {
            if (hygfRectificationOrder.getRectificationIdea() != null){
                hygfRectificationOrder.setRectificationIdeaWeb(formatJsonListWithNumbers(hygfRectificationOrder.getRectificationIdea()));
            }
            if (hygfRectificationOrder.getRectificationHistory() != null){
                hygfRectificationOrder.setRectificationHistoryWeb(formatJsonListWithNumbers(hygfRectificationOrder.getRectificationHistory()));
            }
            if (hygfRectificationOrder.getRectificationResult() != null){
                hygfRectificationOrder.setRectificationResultWeb(formatJsonListWithNumbers(hygfRectificationOrder.getRectificationResult()));
            }
        }
        return hygfRectificationOrders;
    }


    public static String formatListWithNumbers(List<String> items) {
        return IntStream.range(0, items.size())
                .mapToObj(index -> (index + 1) + ". " + items.get(index) + "\n")
                .collect(Collectors.joining());
    }


    public static String formatJsonListWithNumbers(List<Object> items) {
        return IntStream.range(0, items.size())
                .mapToObj(index -> {
                    JSONObject item = (JSONObject) items.get(index);
                    String value = item.getString("value");
                    return (index + 1) + ". " + value + "\n";
                })
                .collect(Collectors.joining());
    }
}