package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.hygf.api.dto.HistoryPeasantHouseholdDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordExportDTO;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingRegional;
import com.yeejoin.amos.boot.module.hygf.api.entity.IcbcWithholdRecord;
import com.yeejoin.amos.boot.module.hygf.api.mapper.IcbcWithholdRecordMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IIcbcWithholdRecordService;
import com.yeejoin.amos.boot.module.hygf.api.dto.IcbcWithholdRecordDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-12-06
 */
@Service
public class IcbcWithholdRecordServiceImpl extends BaseService<IcbcWithholdRecordDto,IcbcWithholdRecord,IcbcWithholdRecordMapper> implements IIcbcWithholdRecordService {
    /**
     * 分页查询
     */

    @Autowired
    IcbcWithholdRecordMapper icbcWithholdRecordMapper;
    public Page<IcbcWithholdRecordDto> queryForIcbcWithholdRecordPage(int current,int size,IcbcWithholdRecordDto dto)   {


        Page<IcbcWithholdRecordDto> page = new Page<>();
        PageHelper.startPage(current,size);
        List<IcbcWithholdRecordDto>  dtos = icbcWithholdRecordMapper.exportData(dto);

        PageInfo<IcbcWithholdRecordDto> pageInfo = new PageInfo<>(dtos);
        page.setSize(pageInfo.getSize());
        page.setCurrent(pageInfo.getPageNum());
        page.setTotal(pageInfo.getTotal());
        page.setRecords(dtos);

        return page;

    }

    /**
     * 列表查询 示例
     */
    public List<IcbcWithholdRecordDto> queryForIcbcWithholdRecordList()   {
        return this.queryForList("" , false);
    }


    public 	void exportData(HttpServletResponse response, String developerCode, String regionalCompaniesCode, String province, String city, String district,String year,String month,String quarter ){
        List<String> quarters = null;
        if (StringUtils.isNotEmpty(quarter)){
            String[] split = quarter.split("-");
            quarters = DateUtils.getMonthsInQuarterAsString(Integer.parseInt(split[0]),Integer.parseInt(split[1]));
        }
        IcbcWithholdRecordDto dto = new IcbcWithholdRecordDto();
        dto.setWithholdStatus("成功");
        List<IcbcWithholdRecordDto>  dtos = this.getBaseMapper().exportTotal(developerCode, regionalCompaniesCode, province, city, district,year,month,quarters,dto);
        if (CollectionUtil.isNotEmpty(dtos)){
            ExcelUtil.createTemplate(response,"结算金额","结算金额",dtos, IcbcWithholdRecordDto.class,null,false);
        }

    }


    public 	Map<String, Object> paymentAmount(String developerCode, String regionalCompaniesCode, String province, String city, String district,String year,String month,String quarter ){
        List<String> quarters = null;
        if (StringUtils.isNotEmpty(quarter)){
            String[] split = quarter.split("-");
            quarters = DateUtils.getMonthsInQuarterAsString(Integer.parseInt(split[0]),Integer.parseInt(split[1]));
        }
        IcbcWithholdRecordDto dto = new IcbcWithholdRecordDto();
        dto.setWithholdStatus("成功");
        List<IcbcWithholdRecordDto>  dtos = this.getBaseMapper().exportTotal(developerCode, regionalCompaniesCode, province, city, district,year,month,quarters,dto);
        double totalPaymentAmount = dtos.stream()
                .mapToDouble(IcbcWithholdRecordDto::getPaymentAmount)
                .sum();
        Map<String, Object> paymentAmount = MapBuilder.<String, Object>create().put("paymentAmount", totalPaymentAmount).build();
        return paymentAmount;
    }
}