package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "idx业务前置接口")
@RequestMapping(value = "/idx")
public class IdxBizTableController extends BaseController{

	@Autowired
	IIdxBizTableService idxBizTableService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "分页查询业务事实表的数据", notes = "分页查询业务事实表的数据-IDX前置接口")
	@GetMapping(value = "/table/getPage")
	public ResponseModel<Page<Map<String, Object>>> getTablePage(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(idxBizTableService.getPage(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "分页查询业务事实表的数据", notes = "分页查询业务事实表的数据-IDX前置接口")
	@GetMapping(value = "/table/getPageO")
	public ResponseModel<Page<Map<String, Object>>> getPageO(@RequestParam Map<String, Object> map) {
		return ResponseHelper.buildResponse(idxBizTableService.getPageO(map));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "列表下拉框选项数据", notes = "列表下拉框选项数据")
	@GetMapping(value = "/select-options")
	public ResponseModel<List<Map<String, Object>>> getSelectOptions() throws UnsupportedEncodingException {
		String queryString = request.getQueryString();
		String[] paramPairs = queryString.split("&");
		Map<String, String> params = new HashMap<>();
		for (String paramPair : paramPairs) {
			String[] keyValue = paramPair.split("=");
			String key = keyValue[0];
			String value = keyValue[1];
			value = URLDecoder.decode(value, "utf-8");
			params.put(key, value);
		}
		List<Map<String, Object>> selectOptions = idxBizTableService.getSelectOptions(params);
		return ResponseHelper.buildResponse(selectOptions);
	}
}
