package com.yeejoin.amos.boot.module.jxiop.biz.service;


import com.yeejoin.amos.boot.module.jxiop.biz.dto.HealthIndexDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndex;

import java.util.List;

/**
 * <p>
 * ProjectName: amos-boot-zx-biz
 * PackageName: com.yeejoin.amos.boot.module.jxiop.biz.service
 *
 * @author yangyang
 * @version v1.0
 * @date 2024/7/23 21:55
 */
public interface IFanHealthIndexService {

    List<FanHealthIndex> getInfoListByGroupByCdFan(String startTime, String tableName, String analysisObjectType);

    List<FanHealthIndex> getInfoListByGroupByZxtFan(String startTime, String tableName, String analysisObjectType);

    /**
     * 设备加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<FanHealthIndex> getInfoListByGroupBySbFan(String startTime, String tableName, String analysisObjectType);

    /**
     * 场站加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<FanHealthIndex> getInfoListByGroupByCzFan(String startTime, String tableName, String analysisObjectType);

    /**
     * 区域加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<FanHealthIndex> getInfoListByGroupByQyFan(String startTime, String tableName, String analysisObjectType);

    /**
     * 全域【所有 / 全国】加权平均
     * 加权平均数 = (w1 * x1 + w2 * x2 + … + wn * xn) / (w1 + w2 + … + wn)
     * w1, w2, …, wn 是各个数据点的权重；
     * x1, x2, …, xn 是各个数据点的数值；
     * n 是数据点的总数。
     *
     * @param startTime          startTime
     * @param tableName          tableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< FanHealthIndex>}
     * @throws
     * @author yangyang
     * @date 2024/7/23 21:02
     */
    List<FanHealthIndex> getInfoListByGroupByQgFan(String startTime, String tableName, String analysisObjectType);

    /**
     * 光伏 & 风电加权平均计算 ：区域
     *
     *
     * @param startTime startTime
     * @param fanTableName fanTableName
     * @param pvTableName pvTableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< HealthIndexDTO>}
     * @author yangyang
     * @throws
     * @date 2024/7/25 14:01
     */
    List<HealthIndexDTO> getInfoListByGroupByQy(String startTime, String fanTableName, String pvTableName, String analysisObjectType);

    /**
     * 光伏 & 风电加权平均计算 ：全域【所有 / 全国】
     *
     *
     * @param startTime startTime
     * @param fanTableName fanTableName
     * @param pvTableName pvTableName
     * @param analysisObjectType analysisObjectType
     * @return {@link  List< HealthIndexDTO>}
     * @author yangyang
     * @throws
     * @date 2024/7/25 14:01
     */
    List<HealthIndexDTO> getInfoListByGroupByQg(String startTime, String fanTableName, String pvTableName, String analysisObjectType);

    FanHealthIndex toFanHealthIndex(HealthIndexDTO healthIndex);

    PvHealthIndex toPvHealthIndex(HealthIndexDTO healthIndex);
}
