package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanPointTagDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointTag;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointTagMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizFanPointTagService;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizFanPointTagServiceImpl extends BaseService<IdxBizFanPointTagDto,IdxBizFanPointTag,IdxBizFanPointTagMapper> implements IIdxBizFanPointTagService {
    /**
     * 分页查询
     */
    public Page<IdxBizFanPointTagDto> queryForIdxBizFanPointTagPage(Page<IdxBizFanPointTagDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizFanPointTagDto> queryForIdxBizFanPointTagList() {
        return this.queryForList("", false);
    }


    public List<Map<String,Object>> selectForListByParams(Map<String, Object> map) {

        LambdaQueryWrapper<IdxBizFanPointTag> queryWrapper = new LambdaQueryWrapper<>();

        List<Map<String,Object>> result = new ArrayList<>();
        if (ObjectUtils.isEmpty(map)) {
            queryWrapper.groupBy(IdxBizFanPointTag::getArae);
            List<IdxBizFanPointTag> idxBizFanPointTags = this.getBaseMapper().selectList(queryWrapper);
            for (IdxBizFanPointTag idxBizFanPointTag : idxBizFanPointTags) {
                Map<String,Object> maps = new HashMap<>();
                map.put("value",idxBizFanPointTag.getArae());
                result.add(map);
            }
        } else if (map.containsKey("ARAE") && !map.containsKey("STATION")) {
            queryWrapper.eq(IdxBizFanPointTag::getArae, map.get("ARAE"));
            queryWrapper.groupBy(IdxBizFanPointTag::getStation);
            List<IdxBizFanPointTag> idxBizFanPointTags = this.getBaseMapper().selectList(queryWrapper);
            for (IdxBizFanPointTag idxBizFanPointTag : idxBizFanPointTags) {
                Map<String,Object> maps = new HashMap<>();
                map.put("value",idxBizFanPointTag.getStation());
                result.add(map);
            }
        } else if (map.containsKey("STATION")) {
            queryWrapper.eq(IdxBizFanPointTag::getArae, map.get("ARAE"));
            queryWrapper.eq(IdxBizFanPointTag::getStation, map.get("STATION"));
            queryWrapper.groupBy(IdxBizFanPointTag::getNumber);
            List<IdxBizFanPointTag> idxBizFanPointTags = this.getBaseMapper().selectList(queryWrapper);
            for (IdxBizFanPointTag idxBizFanPointTag : idxBizFanPointTags) {
                Map<String,Object> maps = new HashMap<>();
                map.put("value",idxBizFanPointTag.getNumber());
                result.add(map);
            }
        }

        return result;
    }
}