package com.yeejoin.amos.boot.module.jxiop.api.dto;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CommonFile;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="HouseholdPvContactDto", description="户用光伏合同表")
public class HouseholdPvContactDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "户用光伏id")
    private Long householdPvId;

    @ApiModelProperty(value = "备案证号")
    private String number;

    @ApiModelProperty(value = "合同期限")
	@TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> period;

    @ApiModelProperty(value = "合同描述")
    private String description;

    @ApiModelProperty(value = "屋顶租赁及使用协议")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> useAgreement;

    @ApiModelProperty(value = "签约视频")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> signingVideo;

    @ApiModelProperty(value = "备案证明")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> filingCertificate;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "发电户号")
    private String generationNumber;

    @ApiModelProperty(value = "购售电合同")
    private List<CommonFile> powerContract;
}
