package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 人员资质
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "person_certificate", autoResultMap = true)
public class PersonCertificate extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 证件类型
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证书名称
     */
    @TableField("certificate_name")
    private String certificateName;

    /**
     * 取证时间
     */
    @TableField("certificate_time")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date certificateTime;

    /**
     * 发证机关
     */
    @TableField("issuing_authority")
    private String issuingAuthority;

    /**
     * 证书编号
     */
    @TableField("certificate_num")
    private String certificateNum;

    /**
     * 取证项目
     */
    @TableField("certificate_project")
    private String certificateProject;

    /**
     * 有效期限
     */
    @TableField("valid_period")
    private String validPeriod;

    /**
     * 证书等级
     */
    @TableField("certificate_grade")
    private String certificateGrade;

    /**
     * 证书附件
     */
    @TableField(value = "certificate_attachment", typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> certificateAttachment;

    /**
     * 人员信息id
     */
    @TableField("person_id")
    private Long personId;

}
