package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.VisitorRecording;
import org.springframework.data.domain.PageImpl;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/3/1 11:53
 */
public interface IVisitorRecordingService extends IService<VisitorRecording> {

    /**
     * 根据条件分页查询
     * @param visitorName 访客姓名 模糊
     * @param phoneNumber 电话 模糊
     * @param hostName 接待人 模糊
     * @param visitorCompany 来访单位 模糊
     * @param targetDepartmentId 被访部门 精确
     * @param page 分页信息
     * @return 分页数据
     */
    Page listByParams(String visitorName, String phoneNumber, String hostName, String visitorCompany,
                       Long targetDepartmentId, Page page);

    /**
     * 根据id删除
     *
     * @param ids
     * @return
     */
    Boolean deleteByIds(String ids);

    /**
     * 根据查询参数导出数据
     *
     * @param response
     * @param ids
     * @param visitorName
     * @param phoneNumber
     * @param hostName
     * @param visitorCompany
     * @param targetDepartment
     */
    void exportByParams(HttpServletResponse response, List<Long> ids, String visitorName, String phoneNumber, String hostName, String visitorCompany,
                        Long targetDepartment);
}
