package com.yeejoin.amos.boot.module.cas.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.cas.api.service.IdxBizSyncService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-sync", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class IdxBizSyncController {

    @Autowired
    private IdxBizSyncService idxBizSyncService;

    @TycloudOperation(ApiLevel = UserType.AGENCY ,needAuth = false)
    @RequestMapping(value = "/page/{tableName}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    @ResponseBody
    public List listPage(@PathVariable String tableName, @RequestParam Map params) throws Exception{
        int current = Integer.parseInt((String) params.get("current"));
        int size = Integer.parseInt((String) params.get("size"));
        params.remove("current");
        params.remove("size");
        List list = idxBizSyncService.selectAllPageQuery(tableName, params, current, size);
        return list;
    }
}

