package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 运维人员
 *
 * @author system_generator
 * @date 2024-03-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_maintenance",autoResultMap = true)
public class Maintenance extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 运维人员类型名称
     */
    @TableField("maintenance_type")
    private String maintenanceType;

    /**
     * 运维人员类型code
     */
    @TableField("maintenance_type_code")
    private String maintenanceTypeCode;

    /**
     * 运维区域名称
     */
    @TableField("maintenance_area")
    private String maintenanceArea;

    /**
     * 运维区域code
     */
    @TableField(value = "maintenance_area_code",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> maintenanceAreaCode;

    /**
     * 运维工种名称
     */
    @TableField("maintenance_workers")
    private String maintenanceWorkers;

    /**
     * 运维工种code
     */
    @TableField("maintenance_workers_code")
    private String maintenanceWorkersCode;

    /**
     * 所属区域公司id
     */
    @TableField("regional_companies_seq")
    private Long regionalCompaniesSeq;

    /**
     * 所属区域公司名称
     */
    @TableField("regional_companies_name")
    private String regionalCompaniesName;

    /**
     * 所属区域公司code
     */
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;

    /**
     * 业务经销商name
     */
    @TableField("dealer_name")
    private String dealerName;

    /**
     * 业务经销商id
     */
    @TableField("dealer_id")
    private Long dealerId;

    /**
     * 平台经销商单位id
     */
    @TableField(exist = false)
    private Long amosDealerId;
   /**
    *
    * 基础人员表
    * */
    @TableField("foundation_id")
    private Long foundationId;


    /**
     * 平台经销商code
     */
    @TableField(exist = false)
    private String amosDealerCode;

    /**
     * 证件号码
     */
    @TableField(exist = false)
   private String idCard;

    /**
     * 身份证正面
     */

    @TableField(exist = false, typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardFront;
    /**
     * 身份证反面
     */
    @TableField(exist = false, typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardOpposite;
    /**
     * 业主姓名
     */
    @TableField(exist = false)
    private String name;

    /**
     * 联系电话
     */
    @TableField(exist = false)
    private String telephone;

    /**
     * 证件类型
     */
    @TableField(exist = false)
    private String idType;



    /**
     * 管理员账户名
     */
    @TableField(exist = false)
    private String adminLoginName;

    /**
     * 管理员密码
     */
    @TableField(exist = false)
    private String adminLoginPwd;
    /**
     * 平台userId
     */
    @TableField(exist = false)
    private String amosUserId;
    /**
     * 是否锁定
     */
    @TableField(exist = false)
    private String lockStatus;
    /**
     * 低压电工证
     */
    @TableField(exist = false, typeHandler = FastjsonTypeHandler.class)
    private  List<Object> electricianCertificate;

    /**
     * 登高证
     */
    @TableField(exist = false, typeHandler = FastjsonTypeHandler.class)
    private  List<Object> climbingCertificate;

    /**
     * 低压电工证有效期开始
     */
    @TableField(exist = false)
    private Date electricianCertificateStart;

    /**
     * 低压电工证有效期结束
     */
    @TableField(exist = false)
    private Date electricianCertificateEnd;

    /**
     * 登高证有效期开始
     */
    @TableField(exist = false)
    private Date climbingCertificateStart;

    /**
     * 登高证有效期结束
     */
    @TableField(exist = false)
    private Date climbingCertificateEnd;

    /**
     * 培训状态
     */
    @TableField("training_status")
    private String trainingStatus;

    /**
     * 审核状态
     */
    @TableField("review_status")
    private String reviewStatus;





    /**
     * 运维区域详细地址
     */
    @TableField("maintenance_area_address")
    private String maintenanceAreaAddress;

    /**
     * 常住地址code
     */
    @TableField(value ="permanent_address_code",typeHandler = FastjsonTypeHandler.class)
    private List<Integer>  permanentAddressCode;

    /**
     * 常住详细地址
     */
    @TableField("permanent_address_detail")
    private String permanentAddressDetail;

    /**
     * 常住地址
     */
    @TableField("permanent_address_name")
    private String permanentAddressName;

    //证书
    @TableField(exist = false)
    List<MaintenanceFile> maintenanceFiles;
    /**
     * 是否签订安全协议
     */
    @TableField("is_sign_an_agreement")
    private  Integer  isSignAnAgreement ;

}
