package com.yeejoin.amos.boot.module.hygf.api.tdenginemapper;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerCurveDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.DayGenerate;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/11/8
 */
public interface DayGenerateMapper extends BaseMapper<DayGenerate> {

    //日发电量排行
    // desc 前十名
    // asc  后十名
    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<DayGenerate>  getDayGenerateph(@Param("dto") List<JpStation> dto,
                                        @Param("regionalCompaniesCode") String regionalCompaniesCode,
                                        @Param("amosCompanyCode") String amosCompanyCode,
                                        @Param("sort")String sort,
                                        @Param("dateTime")String dateTime);


    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<PowerCurveDto>  getDayGeneratqx(@Param("date") String month, @Param("thirdStationId") String thirdStationId,@Param("dto")List<String> statioId);
    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<PowerCurveDto>  getMonthGenerateqx(@Param("date") String month, @Param("thirdStationId") String thirdStationId, @Param("dto")List<String> statioId);
    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<PowerCurveDto>  getYearGenerateqx(@Param("date") String month, @Param("thirdStationId") String thirdStationId, @Param("dto")List<String> statioId);


    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<DayGenerate> selectPagenewDayGenerate(@Param("current") int current,
                                               @Param("size") int size,@Param("dto")
                                                List<String> statioId,
                                               @Param("dateTime")String dateTime,
                                               @Param("stationState")String stationState);

    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    Integer selectCount(@Param(Constants.WRAPPER) Wrapper<DayGenerate> queryWrapper);

    @UserEmpower(field ={"regional_companies_code"},dealerField ={"amos_company_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<DayGenerate> selectList(@Param(Constants.WRAPPER) Wrapper<DayGenerate> queryWrapper);
}
