package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.SurveyDetailsDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.SurveyDetailsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 勘察明细
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "勘察明细Api")
@RequestMapping(value = "/survey-details")
public class SurveyDetailsController extends BaseController {

    @Autowired
    SurveyDetailsServiceImpl surveyDetailsServiceImpl;

    /**
     * 新增勘察明细
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增勘察明细", notes = "新增勘察明细")
	public ResponseModel<SurveyDetailsDto> save(@RequestBody SurveyDetailsDto model) {
	    model = surveyDetailsServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新勘察明细", notes = "根据sequenceNbr更新勘察明细")
	public ResponseModel<SurveyDetailsDto> updateBySequenceNbrSurveyDetails(@RequestBody SurveyDetailsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(surveyDetailsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除勘察明细", notes = "根据sequenceNbr删除勘察明细")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(surveyDetailsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个勘察明细",  notes = "根据sequenceNbr查询单个勘察明细")
	public ResponseModel<SurveyDetailsDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(surveyDetailsServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "勘察明细分页查询",  notes = "勘察明细分页查询")
	public ResponseModel<Page<SurveyDetailsDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<SurveyDetailsDto> page = new Page<SurveyDetailsDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(surveyDetailsServiceImpl.queryForSurveyDetailsPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "勘察明细列表全部数据查询",   notes = "勘察明细列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SurveyDetailsDto>> selectForList() {
	    return ResponseHelper.buildResponse(surveyDetailsServiceImpl.queryForSurveyDetailsList());
	}
}
