package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 人员基本信息
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PersonAccountDto", description = "人员基本信息")
public class PersonAccountFedDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "平台user_id")
    private String puserId;

    @ApiModelProperty(value = "平台账号名称")
    private String accountName;

    @ApiModelProperty(value = "用户角色")
    private String roles;

    @ApiModelProperty(value = "密码")
    private String password;

    @ApiModelProperty(value = "二次密码")
    private String secondaryPassword;

    @ApiModelProperty(value = "业务密码")
    private String businessPassword;

    @ApiModelProperty(value = "部门id")
    private Long departmentId;

    @ApiModelProperty(value = "部门名称")
    private String projectDepartmentName;

    @ApiModelProperty(value = "所属场站id")
    private Long projectId;

    @ApiModelProperty(value = "工作所在地key")
    private String workPlaceKey;

    @ApiModelProperty(value = "进入本单位工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date stationWorkTime;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "工号")
    private String jobNumber;


    private String departmentName;

    private String projectName;

    @ApiModelProperty(value = "证件类型(0-身份证)")
    private String idType;

    @ApiModelProperty(value = "证件编号")
    private String idNumber;
    /**
     * 应用
     */
    @ApiModelProperty(value = "应用")
    private String application;


    @ApiModelProperty(value = "生产用户类型")
    private String scUserType;

    @ApiModelProperty(value = "生产用户分类")
    private String scUserCategory;
    private Long personId;
}
