package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-索道
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="paramRopeway", description="索道技术参数")
public class EquipTechParamRopewayModel extends BaseDto {
    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "")
        private String instanceId;
            @ApiModelProperty(value = "")
        private String status;
            @ApiModelProperty(value = "")
        private BigDecimal horizontalDistance;
            @ApiModelProperty(value = "支架数目")
        private Integer supportsCount;
            @ApiModelProperty(value = "斜长")
        private BigDecimal obliqueLength;
            @ApiModelProperty(value = "主电机型号和功率")
        private BigDecimal mainMotorModelAndPower;
            @ApiModelProperty(value = "高差")
        private BigDecimal altitudeDifference;
            @ApiModelProperty(value = "张紧油压（重锤）")
        private BigDecimal oilPressureHeavyHammer;
            @ApiModelProperty(value = "张紧油压（油压）")
        private BigDecimal oilPressureOilPressure;
            @ApiModelProperty(value = "运量")
        private BigDecimal freightVolume;
            @ApiModelProperty(value = "运载索")
        private String carrierLine;
            @ApiModelProperty(value = "速度")
        private BigDecimal speed;
            @ApiModelProperty(value = "承载索")
        private String bearingCable;
            @ApiModelProperty(value = "索距")
        private BigDecimal cablePitch;
            @ApiModelProperty(value = "运载工具数量和类型")
        private String numberAndTypeOfVehicles;
            @ApiModelProperty(value = "索引索")
        private String tractionRope;
            @ApiModelProperty(value = "平衡索")
        private String balanceCable;

            @ApiModelProperty(value = "主要部件")
        private String mainComponents;

    
}
