package com.yeejoin.amos.api.householdapi.Utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.yeejoin.amos.api.householdapi.constant.ImasterConstant;

import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.houseapi.HousepvapiRecords;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.houseapi.HYGFThirdStationLog;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.houseapi.HousepvapiRecordsMapper;
import com.yeejoin.amos.api.householdapi.face.service.IHYGFThirdStationLogService;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import lombok.extern.slf4j.Slf4j;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Component
@Slf4j
public class ImasterUtils {

	private String redisKey = "XSRF-TOKEN";

	@Autowired
	HousepvapiRecordsMapper housepvapiRecordsMapper;
	@Autowired
	RedisUtils redisUtils;
	@Autowired
	IHYGFThirdStationLogService thirdStationLogService;

	final static Logger logger = LoggerFactory.getLogger(ImasterUtils.class);

	/**
	 * @return HashMap<String, Object> 发送请求前的准备 准备header信息
	 * @deprecated 根据厂商编码获取厂商的hearer
	 */
	public static HashMap<String, String> getHeader() {
		HashMap<String, String> hashMap = new HashMap<>();
		String requestParam = "";
		HashMap<String, String> hashMaphead = new HashMap<>();
		try {
			requestParam = "{ \"userName\": \"" + ImasterConstant.account + "\", \"systemCode\": \""
					+ ImasterConstant.password + "\"}";
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		String url = ImasterConstant.baseurl + ImasterConstant.tokenUrl;
		HttpResponse execute = HttpUtil.createRequest(Method.POST, url).body(requestParam).execute();
		String token = execute.header("xsrf-token");

		hashMap.put("XSRF-TOKEN", token);
		return hashMap;
	}

	/**
	 * @param apiurl            请求url
	 * @param requestMethod     请求方式
	 * @param requestParmInfo   请求参数mapper
	 * @param ResultResolveRule 请求的解析
	 * @param tClass            需要转换成的bean
	 * @param <T>               泛型数据
	 * @return List<T> list<Result>
	 * @desc 根据请求参数发送http请求并且对于返回的数据进行处理
	 */
	public <T> List<T> getResPonse(String apiurl, String requestMethod, String requestParmInfo,
			String ResultResolveRule, Class<T> tClass) {
		String respone = "";
		String params = "";
		JSONArray jsonArray = null;
		List<T> result = new ArrayList<>();
		HashMap<String, String> headMap =new HashMap<>();
		try {
			Object o = redisUtils.get(redisKey);
			if (o != null) {
				headMap = new HashMap<>();
				headMap.put("XSRF-TOKEN", o.toString());
				String url = ImasterConstant.baseurl + apiurl;
				respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
				JSONObject jsonObject = JSONObject.parseObject(respone);
				if (jsonObject.get("failCode").toString().equals("305")) {
					headMap = getHeader();
					respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
					jsonArray = handlerResponseByResultResolverule(ResultResolveRule, respone);
					if (!ObjectUtils.isEmpty(jsonArray)) {
						result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
						redisUtils.set(redisKey, headMap.get("XSRF-TOKEN"));
					}
				} else {
					jsonArray = handlerResponseByResultResolverule(ResultResolveRule, respone);
					if (!ObjectUtils.isEmpty(jsonArray)) {
						result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
					}
				}
				//存储日志
				HYGFThirdStationLog hygfThirdStationLog = new HYGFThirdStationLog();
				hygfThirdStationLog.setThirdCode(PVProducerInfoEnum.HUAWEI.getCode());
				hygfThirdStationLog.setReqMethod(requestMethod);
				hygfThirdStationLog.setReqHeaders(headMap.toString());
				hygfThirdStationLog.setReqPath(url);
				hygfThirdStationLog.setReqBody(requestParmInfo);
				hygfThirdStationLog.setResBody(respone);
				thirdStationLogService.saveLog(hygfThirdStationLog);
			} else {
				headMap = getHeader();
				String url = ImasterConstant.baseurl + apiurl;
				respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
				jsonArray = handlerResponseByResultResolverule(ResultResolveRule, respone);
				if (!ObjectUtils.isEmpty(jsonArray)) {
					result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
					redisUtils.set(redisKey, headMap.get("XSRF-TOKEN"));
				}
				//存储日志
				HYGFThirdStationLog hygfThirdStationLog = new HYGFThirdStationLog();
				hygfThirdStationLog.setThirdCode(PVProducerInfoEnum.HUAWEI.getCode());
				hygfThirdStationLog.setReqMethod(requestMethod);
				hygfThirdStationLog.setReqHeaders(headMap.toString());
				hygfThirdStationLog.setReqPath(url);
				hygfThirdStationLog.setReqBody(requestParmInfo);
				hygfThirdStationLog.setResBody(respone);
				thirdStationLogService.saveLog(hygfThirdStationLog);
			}
		} catch (Exception exception) {
			//存储日志
			HYGFThirdStationLog hygfThirdStationLog = new HYGFThirdStationLog();
			hygfThirdStationLog.setThirdCode(PVProducerInfoEnum.HUAWEI.getCode());
			hygfThirdStationLog.setReqMethod(requestMethod);
			hygfThirdStationLog.setReqHeaders(headMap.toString());
			hygfThirdStationLog.setReqPath(ImasterConstant.baseurl + apiurl);
			hygfThirdStationLog.setReqBody(requestParmInfo);
			hygfThirdStationLog.setResBody(respone);
			thirdStationLogService.saveLog(hygfThirdStationLog);
			return result;
		}
		return result;
	}

	/**
	 * @param apiurl            请求url
	 * @param requestMethod     请求方式
	 * @param requestParmInfo   请求参数mapper
	 * @param ResultResolveRule 请求的解析
	 * @param tClass            需要转换成的bean
	 * @param <T>               泛型数据
	 * @return List<T> list<Result>
	 * @desc 根据请求参数发送http请求并且对于返回的数据进行处理
	 */
	public <T> List<T> getResPonseOther(String apiurl, String requestMethod, String requestParmInfo,
			String ResultResolveRule, Class<T> tClass) {
		String respone = "";
		String params = "";
		JSONArray jsonArray = null;
		List<T> result = new ArrayList<>();
		HashMap<String, String> headMap = new HashMap<>();
		try {
			Object o = redisUtils.get(redisKey);
			if (o != null) {
				headMap = new HashMap<>();
				headMap.put("XSRF-TOKEN", o.toString());
				String url = ImasterConstant.baseurl + apiurl;
				respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
				JSONObject jsonObject = JSONObject.parseObject(respone);
				if (jsonObject.get("failCode").toString().equals("305")) {
					headMap = getHeader();
					respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
					jsonArray = handlerResponseByResultResolveruleOther(ResultResolveRule, respone);
					if (!ObjectUtils.isEmpty(jsonArray)) {
						result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
						redisUtils.set(redisKey, headMap.get("XSRF-TOKEN"));
					}
				} else {
					jsonArray = handlerResponseByResultResolveruleOther(ResultResolveRule, respone);
					if (!ObjectUtils.isEmpty(jsonArray)) {
						try {
							result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
						} catch (Exception e) {
							e.printStackTrace();
							logger.error("华为数据解析错误(getResPonseOther):" + jsonArray.toJSONString());
						}
					}
				}
				//存储日志
				HYGFThirdStationLog hygfThirdStationLog = new HYGFThirdStationLog();
				hygfThirdStationLog.setThirdCode(PVProducerInfoEnum.HUAWEI.getCode());
				hygfThirdStationLog.setReqMethod(requestMethod);
				hygfThirdStationLog.setReqHeaders(headMap.toString());
				hygfThirdStationLog.setReqPath(url);
				hygfThirdStationLog.setReqBody(requestParmInfo);
				hygfThirdStationLog.setResBody(respone);
				thirdStationLogService.saveLog(hygfThirdStationLog);
			} else {
				headMap = getHeader();
				String url = ImasterConstant.baseurl + apiurl;
				respone = sendRequest(requestMethod, url, requestParmInfo, headMap);
				jsonArray = handlerResponseByResultResolveruleOther(ResultResolveRule, respone);
				if (!ObjectUtils.isEmpty(jsonArray)) {
					result = JSONArray.parseArray(jsonArray.toJSONString(), tClass);
					redisUtils.set(redisKey, headMap.get("XSRF-TOKEN"));
				}
				//存储日志
				HYGFThirdStationLog hygfThirdStationLog = new HYGFThirdStationLog();
				hygfThirdStationLog.setThirdCode(PVProducerInfoEnum.HUAWEI.getCode());
				hygfThirdStationLog.setReqMethod(requestMethod);
				hygfThirdStationLog.setReqHeaders(headMap.toString());
				hygfThirdStationLog.setReqPath(url);
				hygfThirdStationLog.setReqBody(requestParmInfo);
				hygfThirdStationLog.setResBody(respone);
				thirdStationLogService.saveLog(hygfThirdStationLog);
			}
		} catch (Exception exception) {
			exception.printStackTrace();
			//存储日志
			HYGFThirdStationLog hygfThirdStationLog = new HYGFThirdStationLog();
			hygfThirdStationLog.setThirdCode(PVProducerInfoEnum.HUAWEI.getCode());
			hygfThirdStationLog.setReqMethod(requestMethod);
			hygfThirdStationLog.setReqHeaders(headMap.toString());
			hygfThirdStationLog.setReqPath(ImasterConstant.baseurl + apiurl);
			hygfThirdStationLog.setReqBody(requestParmInfo);
			hygfThirdStationLog.setResBody(respone);
			thirdStationLogService.saveLog(hygfThirdStationLog);
			return result;
		}
		return result;
	}

	/**
	 * @param resultResovle 请求返回的解析规则 来源与数据库
	 * @param response      请求返回的字符串
	 * @return 解析后的数据
	 * @desc 根据解析规则解析请求返回数据
	 */
	public static JSONArray handlerResponseByResultResolverule(String resultResovle, String response) {
		JSONObject jsonObject = JSONObject.parseObject(response);
		JSONArray jsonArray = new JSONArray();
		if (ObjectUtil.isNotEmpty(resultResovle)) {
			String[] rules = resultResovle.split(",");
			if (rules.length > 0) {
				for (int i = 0; i < rules.length; i++) {
					try {
						jsonObject = (JSONObject) jsonObject.get(rules[i]);
						if (jsonObject == null) {
							jsonArray = (JSONArray) jsonObject.get(rules[i]);
						}
					} catch (Exception exception) {
						jsonArray = (JSONArray) jsonObject.get(rules[i]);
					}
				}
			}
			if (jsonArray.size() == 0) {
				jsonArray.addAll((JSONArray) jsonObject.get("list"));
			}
		}
		return jsonArray;
	}

	/**
	 * @param resultResovle 请求返回的解析规则 来源与数据库
	 * @param response      请求返回的字符串
	 * @return 解析后的数据
	 * @desc 根据解析规则解析请求返回数据
	 */
	public static JSONArray handlerResponseByResultResolveruleOther(String resultResovle, String response) {
		JSONObject jsonObject = JSONObject.parseObject(response);
		JSONArray jsonArray = new JSONArray();
		JSONArray jsonArrayRet = new JSONArray();
		if (ObjectUtil.isNotEmpty(resultResovle)&&ObjectUtil.isNotEmpty(jsonObject)) {
			String[] rules = resultResovle.split(",");
			if (rules.length > 0) {
				for (int i = 0; i < rules.length; i++) {
					if ("ACCESS_FREQUENCY_IS_TOO_HIGH".equals(jsonObject.get(rules[i]))) {
						logger.error("华为数据解析错误(handlerResponseByResultResolveruleOther):请求系统次数太频繁,无法获取接口数据");
						continue;
					}
					try {
						jsonObject = (JSONObject) jsonObject.get(rules[i]);
					} catch (Exception exception) {
						try {
							jsonArray = (JSONArray) jsonObject.get(rules[i]);
						} catch (Exception e) {
							e.printStackTrace();
							logger.error("华为数据解析错误:" + jsonObject.get(rules[i]));
						}
					}
				}
			}
			if (jsonArray.size() != 0) {
				for (int i = 0; i < jsonArray.size(); i++) {
					JSONObject jsonObject1 = (JSONObject) jsonArray.get(i);
					if (jsonObject1.get("dataItemMap") != null) {
						JSONObject jsonObject2 = (JSONObject) jsonObject1.get("dataItemMap");
						if (jsonObject1.get("sn") != null) {
							jsonObject2.put("inverterId", jsonObject1.get("sn").toString());
						}
						if (jsonObject1.get("stationCode") != null) {
							jsonObject2.put("stationCode", jsonObject1.get("stationCode").toString());
						}
						if (jsonObject1.get("collectTime") != null) {
							jsonObject2.put("collectTime", jsonObject1.get("collectTime").toString());
						}

						jsonArrayRet.add(jsonObject2);
					}
				}
			}
		}
		return jsonArrayRet;
	}

	public String sendRequest(String requestMethod, String url, String params, HashMap<String, String> headMap) {
		HousepvapiRecords housepvapiRecords = new HousepvapiRecords();
		housepvapiRecords.setRecDate(new Date());
		housepvapiRecords.setRequestUrl(url);
		housepvapiRecords.setRequestMothed(requestMethod);
		housepvapiRecords.setRequestHeaders(JSONObject.toJSONString(headMap));
		housepvapiRecords.setRequestParams(params);
		housepvapiRecords.setThridCode(PVProducerInfoEnum.HUAWEI.getCode());
		String respone = "";
		if (requestMethod.equals("POST")) {
			respone = HttpUtil.createPost(url).headerMap(headMap, false).body(params).execute().body();
		}
		if (requestMethod.equals("GET")) {
			respone = HttpUtil.createGet(url).headerMap(headMap, true).body(params).execute().body();
		}
		housepvapiRecords.setResponse(respone);
		// housepvapiRecordsMapper.insert(housepvapiRecords);
		// log.info("华为数据请求详情："+JSONObject.toJSONString(housepvapiRecords));
		return respone;
	}

	/***
	 *
	 * @param params               参数字符窜
	 * @param headMap              header头
	 * @param orginalAuthorization 原始的orginalAuthorization
	 * @param appsecret            appsecret
	 * @desc 锦浪云请求参数及head头处理
	 */
	public void JLYHeaderMapHandler(String params, HashMap<String, String> headMap, String orginalAuthorization,
			String appsecret, String apiurl) {
		String contentMD5 = GoLangHeaderUtils.getDigest(params);
		headMap.put("Date", GoLangHeaderUtils.getGMTTime());
		String param = "POST" + "\n" + contentMD5 + "\n" + "application/json" + "\n" + headMap.get("Date") + "\n"
				+ apiurl;
		String sign = "";
		try {
			sign = GoLangHeaderUtils.HmacSHA1Encrypt(param, appsecret);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		headMap.put("Content-MD5", contentMD5);
		headMap.put("Authorization", orginalAuthorization + sign);
	}

	/**
	 * @param pageSizeResovle
	 * @param response
	 * @return
	 * @desc 根据分页规则 获取分页数
	 */
	public Integer getPagesize(String pageSizeResovle, String response) {
		Integer pageSize = 0;
		String[] rules = pageSizeResovle.split(",");
		JSONObject jsonObject = JSONObject.parseObject(response);
		if (rules.length > 0) {
			for (int i = 0; i < rules.length - 1; i++) {
				jsonObject = (JSONObject) jsonObject.get(rules[i]);
			}
		}
		pageSize = (Integer) jsonObject.get(rules[rules.length - 1]);
		return pageSize;
	}

//    public static void main(String[] args) {
//        HashMap<String, Object> requestInfo = new HashMap<>();
//        requestInfo.put("pageNo", 1);
//        String requestParaminfo = JSON.toJSONString(requestInfo);
//            getResPonse(ImasterConstant.stationListUrl,
//                GoLangConstant.requestPost,
//                requestParaminfo,
//                ImasterConstant.resovleRule_data_page_records,
//                ImasterStationList.class
//        );
//
//    }
}
