package com.yeejoin.amos.api.householdapi.face.orm.mapper.houseapi;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.houseapi.HYGFThirdStationLog;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

public interface HYGFThirdStationLogMapper extends BaseMapper<HYGFThirdStationLog> {
    // 创建新的数据表
    @Select("CREATE TABLE IF NOT EXISTS ${tableName}  (\n" +
            "  `id` varchar(256) NOT NULL,\n" +
            "  `third_code` varchar(30),\n" +
            "  `req_time` datetime(0),\n" +
            "  `req_method` varchar(20),\n" +
            "  `req_path` varchar(1000),\n" +
            "  `req_headers` varchar(1000),\n" +
            "  `req_body` longtext,\n" +
            "  `res_body` longtext,\n" +
            "  PRIMARY KEY (`id`) USING BTREE\n" +
            ");")
    void createTable(@Param("tableName")String tableName);

    // 插入数据到指定表
    @Insert("INSERT INTO ${tableName} (`id`,`third_code`,`req_time`,`req_method`,`req_path`,`req_headers`,`req_body`,`res_body`) VALUES (#{thirdStationLog.id},#{thirdStationLog.thirdCode},#{thirdStationLog.reqTime},#{thirdStationLog.reqMethod},#{thirdStationLog.reqPath},#{thirdStationLog.reqHeaders},#{thirdStationLog.reqBody},#{thirdStationLog.resBody})")
    void insertData(@Param("tableName") String tableName, @Param("thirdStationLog")HYGFThirdStationLog thirdStationLog);

    // 删除超过时间的表
    @Select("DROP TABLE IF EXISTS ${tableName}")
    void dropTable(@Param("tableName")String tableName);

    //获取表数量
    @Select("SELECT COUNT(1) FROM information_schema.tables WHERE table_name LIKE #{tableName}")
    Integer countTable(@Param("tableName")String tableName);

    //获取最老的表名称
    @Select("SELECT table_name FROM information_schema.tables WHERE table_name LIKE #{tableName} ORDER BY table_name ASC LIMIT 1")
    String getOldestTableName(@Param("tableName")String tableName);
}
