package com.yeejoin.equipmanage.common.dto;

import lombok.Data;

import java.util.Date;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.dto
 * @ClassName: MaintenanceResourceDto
 * @Author: Jianqiang Gao
 * @Description: MaintenanceResourceDto
 * @Date: 2021/7/20 9:06
 * @Version: 1.0
 */
@Data
public class MaintenanceResourceDataDto {

    /**
     * 维保单位ID
     */
    private Long maintenanceCompanyId;

    /**
     * 维保单位名称
     */
    private String maintenanceCompanyName;

    /**
     * 业主单位ID
     */
    private Long ownerUnitId;

    /**
     * 业主单位名称
     */
    private String ownerUnitName;

    /**
     * 消防系统ID
     */
    private Long fireFightSysId;

    /**
     * 消防系统名称
     */
    private String fireFightSysName;

    /**
     * 分类ID
     */
    private Long classifyId;

    /**
     * 分类名称
     */
    private String classifyName;

    /**
     * 分类编码
     */
    private String classifyCode;

    /**
     * 分类类型
     */
    private String classifyType;

    /**
     * 维保设施数量
     */
    private Integer amount;

    /**
     * 到期数量
     */
    private Integer expirationAmount;

    /**
     * 消防设施ID
     */
    private Long fireFacilityId;

    /**
     * 消防设施编码
     */
    private String fireFacilityCode;

    /**
     * 消防设施名称
     */
    private String fireFacilityName;

    /**
     * 消防设施类型
     */
    private String fireFacilityType;

    /**
     * 维保设施状态
     */
    private String status;

    /**
     * 维保设施状态文本
     */
    private String statusText;

    /**
     * 维保周期
     */
    private Integer maintenanceCycle;

    /**
     * 维保到期时间
     */
    private Date maintenanceExpirationTime;

    /**
     * 维保时间
     */
    private Date maintenanceTime;

    /**
     * 位置
     */
    private String location;
    /**
    * 图片
    * */
    private String img;
    /**
     * 消防装备编码
     * */
    private String code;

}