package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.vo.StockDataVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_stock_bill")
@ApiModel(value = "StockBill对象", description = "")
public class StockBill extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "单据编码")
	@TableField(value = "bill_code")
	private String billCode;

	@ApiModelProperty(value = "单据类型")
	@TableField(value = "bill_type")
	private String billType;

	@ApiModelProperty(value = "经手人id")
	@TableField(value = "agent_user_id")
	private Long agentUserId;

	@ApiModelProperty(value = "更新时间")
	@TableField(value = "update_date")
	private Date updateDate;

	@ApiModelProperty(value = "备注")
	@TableField(value = "remark")
	private String remark;

	@ApiModelProperty(value = "仓库ID")
	@TableField(value = "warehouse_id")
	private Long warehouseId;

	@ApiModelProperty(value = "附件")
	private String attachment;

	@ApiModelProperty(value = "创建人ID")
	@TableField(value = "creator_id", fill = FieldFill.INSERT)
	private Long creatorId;

	@ApiModelProperty(value = "创建人名")
	@TableField(value = "creator_name", fill = FieldFill.INSERT)
	private String creatorName;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

	@TableField(exist = false)
	private List<StockDataVO> stockDataVOS;

}
