package com.yeejoin.equipmanage.common.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * co_access_recording
 *
 * @author
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("co_visitor_recording")
@ApiModel(value = "VisitorRecording对象", description = "")
public class VisitorRecording extends BaseEntity {

    /**
     * 登记号
     */
    @ExcelProperty(value = "登记号", index = 0)
    private String recordingCode;

    /**
     * 来访时间
     */
    @ExcelProperty(value = "来访时间", index = 1)
    private Date visitorTime;

    /**
     * 离场时间
     */
    @ExcelProperty(value = "离场时间", index = 2)
    private Date departureTime;

    /**
     * 访客姓名
     */
    @ExcelProperty(value = "访客姓名", index = 3)
    private String visitorName;

    /**
     * 电话
     */
    @ExcelProperty(value = "电话", index = 4)
    private String phoneNumber;

    /**
     * 证件号码
     */
    @ExcelProperty(value = "证件号码", index = 5)
    private String identityNumber;

    /**
     * 来访人数
     */
    @ExcelProperty(value = "来访人数", index = 6)
    private Integer visitorsNumber;

    /**
     * 来访单位
     */
    @ExcelProperty(value = "来访单位", index = 7)
    private String visitorCompany;

    /**
     * 来访事由
     */
    @ExcelProperty(value = "来访事由", index = 8)
    private String visitCause;

    /**
     * 携带物品
     */
    @ExcelProperty(value = "携带物品", index = 9)
    private String carryingGoods;

    /**
     * 车牌号
     */
    @ExcelProperty(value = "车牌号", index = 10)
    private String carPlate;

    /**
     * 被访部门
     */
    @ExcelProperty(value = "被访部门", index = 11)
    private String targetDepartment;

    /**
     * 被访部门id
     */
    private String targetDepartmentId;

    /**
     * 接待人
     */
    @ExcelProperty(value = "接待人", index = 12)
    private String hostName;

    /**
     * 是否删除（0：未删除，1：已删除）
     */
    @TableLogic
    @TableField(select = false)
    private Integer deleted;

    private static final long serialVersionUID = 1L;
}