package com.yeejoin.equipmanage.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.equipmanage.common.entity.SourceFile;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class BuildingAuditVO {

    // 主键
    private Long id;

    // 建筑id
    private Long buildingId;

    // 建筑名称
    private String buildingName;

    // 审核类型
    private String auditTypeId;

    // 审核类型名称
    private String auditTypeName;

    // 审核单位
    private String auditUnit;

    // 审核时间
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date auditTime;

    // 审核资料文件
    private List<SourceFile> auditFile;

    // 是否删除
    private Boolean isDelete;

    // 开始时间
    private String startTime;

    // 结束时间
    private String endTime;
}
