package com.yeejoin.equipmanage.common.vo;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.vo
 * @ClassName: ConfirmAlamVo
 * @Author: Jianqiang Gao
 * @Description: ConfirmAlamVo
 * @Date: 2021/9/16 11:31
 * @Version: 1.0
 */
@Data
@RuleFact(value = "确警消息",project = "消息规则")
public class IotSystemAlarmRo implements Serializable {

    private static final long serialVersionUID = 4301780736505992737L;

    @Label(value = "物联警情id")
    private Long id;

    @Label(value = "联系人")
    private String contactUser;

    @Label(value = "联系人电话")
    private String contactPhone;

    @Label(value = "事发单位")
    private String unitInvolvedId;

    @Label(value = "事发单位名称")
    private String unitInvolvedName;

    @Label(value = "建筑经度")
    private Double longitude;

    @Label(value = "建筑纬度")
    private Double latitude;

    @Label(value = "地址")
    private String address;

    @Label(value = "火灾地址")
    private String fireLocation;

    @Label(value = "楼经度")
    private Double floorLongitude;

    @Label(value = "楼纬度")
    private Double floorLatitude;

    @Label(value = "发送到web标识")
    private Boolean isSendWeb;

    @Label("关联id")
    private String relationId;

    @Label("消息类型")
    private String msgType;

    @Label(value = "终端标识")
    private String terminal;

    @Label(value = "类别")
    private Integer category;

    @Label(value = "扩展参数")
    private Map<String, String> extras;
}