package com.yeejoin.equipmanage.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wujiang
 * @date 2020.09.21
 */
@Data
@ApiModel(description = "扫码返回设备信息")
public class ScanEquipmentBasicInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "保养周期")
	public Short maintenanceCycle;

	@ApiModelProperty(value = "装备名称")
	public String equipName;

	@ApiModelProperty(value = "装备编码")
	public String equipmentCode;

	@ApiModelProperty(value = "装备分类名称")
	public String equipCate;

	@ApiModelProperty(value = "装备分类编码")
	public String equipCategoryCode;

	@ApiModelProperty(value = "性能指标")
	public String perfQuota;

	@ApiModelProperty(value = "装备id")
	public Long equipmentId;

	@ApiModelProperty(value = "装备明细id")
	public Long equipmentDetailId;

	@ApiModelProperty(value = "视频")
	public String film;

	@ApiModelProperty(value = "图片")
	public String img;

	@ApiModelProperty(value = "单位")
	public String unit;

	@ApiModelProperty(value = "二维码")
	public String qrCode;

	@ApiModelProperty(value = "生产厂家")
	public String manufacturer;

	@ApiModelProperty(value = "规格型号")
	public String standard;

	@ApiModelProperty(value = "供应商")
	public String supplier;

	@ApiModelProperty(value = "品牌")
	public String brand;

	@ApiModelProperty(value = "生产日期")
	public String dateProduced;

	@ApiModelProperty(value = "备注")
	public String remark;

	@ApiModelProperty(value = "合同编号")
	public String contractCode;

	@ApiModelProperty(value = "重要指标")
	public List<EquPropertyResponse> equProperties;

	@ApiModelProperty(value = "个数")
	private Object amount = 1;

	@ApiModelProperty(value = "车牌号")
	private String carNum;

	@ApiModelProperty(value = "位置")
	private String description;
	
	@ApiModelProperty(value = "是否批量")
	boolean singleOrDouble  = false;
}
