package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import com.yeejoin.amos.boot.module.jcs.api.enums.ControllerTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <pre>
 * 联动控制器
 * </pre>
 *
 * @author gwb
 * @version $Id: ControllerDto.java, v 0.1 2021年8月20日 上午10:52:52 gwb Exp $
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ControllerDto", description = "联动控制器")
public class ControllerDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;
    /**
     * 控制站
     */
    @ApiModelProperty(value = "控制站")
    private String station;
    /**
     * ip
     */
    @ApiModelProperty(value = "ip")
    private String ip;
    /**
     * 端口
     */
    @ApiModelProperty(value = "端口")
    private Integer port;
    /**
     * 控制器名称
     */
    @ApiModelProperty(value = "控制器名称")
    private String name;
    /**
     * 控制器类别
     */
    @ApiModelProperty(value = "控制器类别")
    private String type;

    /**
     * 控制器类别枚举
     */
    @ApiModelProperty(value = "控制器类别")
    private ControllerTypeEnum typeEnum;

    /**
     * 控制器类别名称
     */
    @ApiModelProperty(value = "控制器类别名称")
    private String typeDescription;
    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String state;
    /**
     * 关联的消防队伍ID
     */
    @ApiModelProperty(value = "关联的消防队伍ID")
    private String fireTeamSeq;
}
