package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 交接班记录分页查询
 *
 * @author system_generator
 * @date 2021-07-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "jc_shift_change", autoResultMap = true)
public class ShiftChange extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 基本信息id（来源动态表单）
     */
    @TableField("instance_id")
    private Long instanceId;
    /**
     * 值班情况
     */
    @TableField(value = "duty_json", typeHandler = JacksonTypeHandler.class)
    private JSONObject dutyJson;
    /**
     * 力量出动情况
     */
    @TableField(value = "power_json", typeHandler = JacksonTypeHandler.class)
    private JSONObject powerJson;
    /**
     * 交接事宜描述
     */
    @TableField("remark")
    private String remark;

    /**
     * 日常工作
     */
    @TableField("duty_work")
    private String dutyWork;


    /**
     * 所属系统 无值为119系统记录
     */
    @TableField("system_type")
    private String systemType;
}
