package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.module.ccs.api.service.IStatisticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;

/**
 * @author DELL
 */
@RestController
@Api(tags = "融合统计")
@RequestMapping(value = "/statistics")
public class StatisticsController {

    @Autowired
    IStatisticsService iStatisticsService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "告警隐患", notes = "告警隐患")
    @GetMapping(value = "/alarmAndDangerNumCount")
    public ResponseModel alarmAndDangerNumCount(
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode) throws ParseException {
        return ResponseHelper.buildResponse(iStatisticsService.alarmAndDangerNumCount(stationCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询指定区间的告警隐患趋势", notes = "查询指定区间的告警隐患趋势")
    @GetMapping(value = "/alarmAndDangerTrend")
    public ResponseModel alarmAndDangerTrend(
            @ApiParam(value = "开始日期", required = true) @RequestParam(value = "beginDate") String beginDate,
            @ApiParam(value = "结束日期", required = true) @RequestParam(value = "endDate") String endDate,
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode) {
        return ResponseHelper.buildResponse(iStatisticsService.alarmAndDangerTrend(stationCode, beginDate, endDate));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "近一年警情统计", notes = "近一年警情统计")
    @GetMapping(value = "/station/lastYearAlarm")
    public ResponseModel lastYearAlarmCount() {
        return ResponseHelper.buildResponse(iStatisticsService.lastYearAlarmCount());
    }


}
