package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.BaseBill;
import com.yeejoin.equipmanage.common.entity.Stock;
import com.yeejoin.equipmanage.common.entity.StockBill;
import com.yeejoin.equipmanage.common.entity.StockDetail;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IStockService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;

/**
 * 库存台账
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "库存台账Api")
@RequestMapping(value = "/stock", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class StockController extends AbstractBaseController {

	@Autowired
	IStockService iStockService;

	/**
	 * 新增库存台账
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增库存台账", notes = "新增库存台账")
	public boolean saveStock(HttpServletRequest request, @RequestBody Stock stock) {
		return iStockService.save(stock);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iStockService.removeById(id);
	}

	/**
	 * 修改库存台账
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改库存台账", notes = "修改库存台账")
	public boolean updateByIdStock(HttpServletRequest request, @RequestBody Stock stock) {
		return iStockService.updateById(stock);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Stock selectById(HttpServletRequest request, @PathVariable Long id) {
		return iStockService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<Stock> listPage(String pageNum, String pageSize, Stock stock) {

		Page<Stock> pageBean;
		QueryWrapper<Stock> stockQueryWrapper = new QueryWrapper<>();
		Class<? extends Stock> aClass = stock.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(stock);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(stock);
						stockQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(stock);
						stockQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(stock);
						stockQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(stock);
						stockQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<Stock> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iStockService.page(pageBean, stockQueryWrapper);
		return page;
	}

	/**
	 * 入库
	 *
	 * @param type
	 * @return
	 */
	@RequestMapping(value = "/in/{type}", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "入库", notes = "根据id查询")
	public BaseBill in(@RequestBody List<StockDetail> list, @PathVariable String type) throws Exception {
		StockBill stockBill = iStockService.in(list, type, getUserInfo());
		BaseBill baseBill = new BaseBill(stockBill.getBillCode(), getUserInfo().getRealName(),
				DateUtils.getNowStrLong(), stockBill.getId(), stockBill.getStockDataVOS());
		return baseBill;
	}
}
