package com.yeejoin.equipmanage.listener;

import com.alibaba.fastjson.JSON;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqxListener;

import java.util.Map;

/**
 * @author DELL
 */
@Component
@Slf4j
public class IntegratePageDataListener extends EmqxListener {

	 @Autowired
    IFireFightingSystemService fireFightingSystemService;
	 
    @Override
    public void processMessage(String topic, MqttMessage message) throws Exception {
    	if(log.isInfoEnabled()){
            log.info("收到消息主题：{},消息内容：{}",topic, message.toString());
        }
    	Map msg = JSON.parseObject(message.toString());
        if(msg.containsKey("request")){
        	String split = "/";
            if(topic.contains(split)){
                String code = topic.substring(topic.indexOf(split) + 1);
                fireFightingSystemService.integrationPageSysData(code, false);
            }
        }
        
    }
}
