package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentSecificDetailVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/10/30 11:16
 * @since v2.0
 */
@Mapper
public interface EquipmentSpecificIndexMapper extends BaseMapper<EquipmentSpecificIndex> {
    /**
     * <pre>
     * @Description: 通过iot_code查询
     * </pre>
     *
     * @MethodName:
     * @Param: []
     * @Return: List<EquipmentSpecificIndex>
     * @Throws
     * @Author keyong
     * @Date 2020/11/3 17:58
     */
    List<EquipmentSpecificIndex> getEquipmentSpeIndexBySpeIotCode(String iotCode);

    /**
     * <pre>
     * @Description: 通过iot_code查询，用于换流站系统的订阅数据
     * </pre>
     *
     * @MethodName:
     * @Param: []
     * @Return: List<EquipmentSpecificIndex>
     * @Throws
     * @Author keyong
     * @Date 2020/11/11 14:25
     */
    List<EquipmentSpecificIndex> getEquipmentSpeIndexByIotCode(String iotCode);

    List<EquipmentSpecificIndex> getEquipmentSpeIndexByIotCodeAndTrend(String iotCode);

    List<EquipmentSpecificIndex> getEquipmentSpeIndexDataByIotCode(String iotCode);

    /**
     * 通过设备id查询
     *
     * @Author lizehua
     * @Date 2020/11/18 19:40
     */
    List<EquipmentSpecificIndex> getEquipmentSpeIndexByEquipmentSecificId(Long id);

    /**
     * 查询视频
     *
     * @Author lizehua
     * @Date 2020/11/18 19:40
     */
    List<Video> getVideoByEquipmentSecificId(Long id);

    /**
     * 通过设备id查询设备详细信息
     *
     * @Author lizehua
     * @Date 2020/11/18 19:40
     */
    EquipmentSecificDetailVO getEquipmentDetailBySecificId(Long id);

    /**
     * 通过指标id查询信息
     *
     * @Author wujunkai
     * @Date 2021/07/08 17:40
     */
    List<EquipmentIndexVO> getEquipIndexByIndexId(@Param("id") Long id, @Param("equipmentSpecificId") Long equipmentSpecificId);


    List<Map<String, Object>> selectEquProperty(@Param("id") Long id);

    List<Map<String, Object>> selectEquList(@Param("pageNum") int pageNum, @Param("pageSize") int pageSize, @Param("name") String name, @Param("standard") String standard, @Param("manufacturerName") String manufacturerName);

    List<Map<String, Object>> selectEquListcount(@Param("name") String name, @Param("standard") String standard, @Param("manufacturerName") String manufacturerName);

    List<Map<String, Object>> getEquipmentSpeIndexList();

    /**
     * 安裝业务唯一索引更新指标
     *
     * @param equipmentSpecificId 实例id
     * @param equipmentIndexId    指标业务id
     * @param value               更新的值
     */
    void updateIndexValueBatch(@Param("equipmentSpecificId") Long equipmentSpecificId, @Param("list") List<EquipmentSpecificIndex> equipmentSpecificIndices);

    List<EquipmentIndexVO> getEquipSpecificIndexList(EquipmentIndexVO equipmentIndexVo);

    List<EquipmentIndexVO> getEquipIndexBySpecificIdIn(@Param("list") List<String> specificDetails);

    List<EquipmentIndexVO> getEquipIndexByIdIn(@Param("list") List<Long> specificIndexIds);
    
    List<Map<String, Object>> getEquipSpecificIndexByUpdateDateDesc();

    List<EquipmentSpecificIndex> getEquipmentSpeIndexByIotCodeTrend(String iotCode, Integer isTrend, String fieldKey);

    List<Map<String, Object>> getEquipSpecificScrap();

    List<EquipmentSpecificIndex> getEquipIndexInIndex(@Param("list") List<String> listIndex);

    EquipmentSpecificIndex getEquipmentSpeIndexByIndexAddress(String indexAddress,String gatewayId);
}
