package com.yeejoin.equipmanage.quartz;

import com.yeejoin.equipmanage.common.enums.AnalysisReportEnum;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.service.IAnalysisReportLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.Date;

/**
 * @author DELL
 */
@Component
@EnableScheduling
public class AnalysisReportSchedulerJob {

    @Autowired
    private IAnalysisReportLogService iAnalysisReportLogService;
    private final Logger log = LoggerFactory.getLogger(AnalysisReportSchedulerJob.class);
    /**
     * 每天凌晨0点-日报生成
     */
    @Scheduled(cron = "0 0 0 * * ?")
    public void dayReport() throws ParseException {
        Date beginDate = DateUtils.dateAdd(new Date(),-1,false);
        Date endDate = DateUtils.dateAdd(new Date(),-1,false);
        iAnalysisReportLogService.generateReport(AnalysisReportEnum.DAY_REPORT,beginDate,endDate);
    }

    /**
     * 每周1(对应日期的2)凌晨0点-周报生成
     */
    @Scheduled(cron = "0 0 0 ? * 1")
    public void weekReport() throws ParseException {
        Date yestDay = DateUtils.dateAdd(new Date(),-1,false);
        Date beginDate = DateUtils.getFirstDayOfWeek(yestDay);
        Date endDate = DateUtils.getLastDayOfWeek(yestDay);
        iAnalysisReportLogService.generateReport(AnalysisReportEnum.WEEK_REPORT,beginDate,endDate);
    }

    /**
     * 每月第1天凌晨0-月报生成
     */
    @Scheduled(cron="0 0 0 1 * ?")
    public void monthReport() throws ParseException {
        Date yestDay = DateUtils.dateAdd(new Date(),-1,false);
        Date beginDate = DateUtils.getFirstDayOfMonth(yestDay);
        Date endDate = DateUtils.getLastDayOfMonth(yestDay);
        log.warn("monthReport报表开始生成");
        iAnalysisReportLogService.generateMonthReport(AnalysisReportEnum.MONTH_REPORT,beginDate,endDate);
    }
}
