package com.yeejoin.amos.boot.module.jcs.biz.audioToText;

/**
 * 语音转文字关键字查找表
 */
enum AudioKeywordType {
    LOCATION("location", new String[]{"地址", "位置", "地点"}),
    CONTACT("contact", new String[]{"联系人", "联系",}),
    CONTACT_NUMBER("contactNumber", new String[]{"号码", "手机", "手机号", "手机号码"}),
    UNIT("unit", new String[]{"事发单位", "单位", "部门"}),
    PART("part", new String[]{"重点部位", "部位"});

    private String type;
    private String[] keyword;

    AudioKeywordType(String type, String[] keyword) {
        this.type = type;
        this.keyword = keyword;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getKeyword() {
        return keyword;
    }

    public void setKeyword(String[] keyword) {
        this.keyword = keyword;
    }
}
