package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jcs.api.entity.Organization;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrganizationUser;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrganizationMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrganizationUserService;
import com.yeejoin.amos.boot.module.jcs.api.service.OrganizationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "组织机构")
@RequestMapping(value = "/organization-user")
public class OrganizationUserController extends BaseController {

    @Autowired
    private IOrganizationUserService organizationUserService;
    @Autowired
    private OrganizationMapper organizationMapper;
    /**
     * 新增应急小组成员
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增应急小组用户", notes = "新增应急小组用户")
    public ResponseModel<OrganizationUser> save(@RequestBody OrganizationUser organizationUser) {

        int sort = organizationMapper.selectOrganizationUserMaxSort();
        organizationUser.setSort(sort+1);

        return ResponseHelper.buildResponse(organizationUserService.saveOrganization(organizationUser));
    }

    /**
     * 编辑应急小组成员
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "编辑应急小组成员", notes = "编辑应急小组成员")
    public ResponseModel<OrganizationUser> updateByIdDeviceServicing(@RequestBody OrganizationUser organizationUser){
        return ResponseHelper.buildResponse(organizationUserService.updateModelById(organizationUser));
    }

    /**
     * 编辑应急小组成员
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateByTel", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "编辑应急小组成员", notes = "编辑应急小组成员")
    public ResponseModel updateModelByTel(@RequestBody OrganizationUser organizationUser){
        organizationUserService.updateModelByTel(organizationUser);
        return CommonResponseUtil.success();
    }

    @GetMapping(value = "/getDetailsById")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取详情", notes = "获取详情")
    public ResponseModel<OrganizationUser> getDetailsById(@RequestParam() Long id) {
        return ResponseHelper.buildResponse(organizationUserService.getDetailsById(id));
    }

    @GetMapping(value = "/getListPage")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "删除", notes = "根据id删除")
    public ResponseModel<IPage<OrganizationUser>> getListPage(@RequestParam(value = "pageNumber") int pageNumber,
                                                              @RequestParam(value = "pageSize") int pageSize, @RequestParam() Long id) {
        return ResponseHelper.buildResponse(organizationUserService.getListPage(pageNumber, pageSize, id));
    }

    @GetMapping(value = "/page")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "卡片值长列表", notes = "卡片值长列表")
    public ResponseModel<IPage<OrganizationUser>> getPage(@RequestParam(value = "pageNumber", required = false) int pageNumber,
                                                              @RequestParam(value = "pageSize", required = false) int pageSize,
                                                                @RequestParam(value = "tel", required = false) String tel) {
        return ResponseHelper.buildResponse(organizationUserService.getPage(pageNumber, pageSize, tel));
    }

    @GetMapping(value = "/deleteById")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "删除", notes = "根据id删除")
    public ResponseModel deleteById(@RequestParam() Long id) {
        return ResponseHelper.buildResponse(organizationUserService.deleteById(id));
    }
}
