package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.TemplateExtendDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Template;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.TemplateServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
* 模板表
*
* @author tb
* @date 2021-06-17
*/
@RestController
@Api(tags = "模板表Api")
@RequestMapping(value = "/template")
public class TemplateController extends BaseController {

    @Autowired
    TemplateServiceImpl iTemplateService;

    /**
    * 新增模板表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增模板表", notes = "新增模板表")
    public boolean saveTemplate(HttpServletRequest request, @RequestBody Template template){
        return iTemplateService.save(template);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iTemplateService.removeById(id);
    }

    /**
    * 修改模板表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改模板表", notes = "修改模板表")
    public boolean updateByIdTemplate(HttpServletRequest request, @RequestBody Template template){
        return iTemplateService.updateById(template);
    }

    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public Template selectById(HttpServletRequest request, @PathVariable Long id){
        return iTemplateService.getById(id);
    }

    /**
     * 根据模板类型查询
     * @param type
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/info/{type}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据模板类型查询", notes = "根据模板类型查询")
    public ResponseModel<TemplateExtendDto> getByType(@PathVariable String type){
        return ResponseHelper.buildResponse(iTemplateService.getByType(type));
    }

    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<Template> listPage(String pageNum,String pageSize, Template template){

        Page<Template> pageBean;
        QueryWrapper<Template> templateQueryWrapper = new QueryWrapper<>();
        Class<? extends Template> aClass = template.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                ReflectionUtils.makeAccessible(field);
                Object o = field.get(template);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(template);
                        templateQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(template);
                        templateQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(template);
                        templateQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw  new BadRequest("系统异常");
            }
        });
        IPage<Template> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iTemplateService.page(pageBean, templateQueryWrapper);
            return page;
        }
    }

