package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 此处是为了待办提供的流程状态    提供流程Key对应此时流程的状态名称
 */
@Getter
@AllArgsConstructor
public enum FlowKeyTodoEnum {
    TSRZ(1001, "待推送", "AbarbeitungWaitPush", "推送融资"),
    JXSZG(1002, "待整改", "WaitAbarbeitung", "经销商整改"),
    RZSH(1003, "待审核", "FinancingAudit", "融资审核"),
    XXFK(1004, "待放款", "AuditPass", "线下放款"),
    JXSGLYSH(1005, "待经销商管理员审核", "hygf_02", "经销商确认"),
    SJSH(1006, "待设计审核", "hygf_03", "设计审核"),
    TRSH(1007, "待投融审核", "hygf_05", "投融审核"),
    FWSH(1008, "待法务审核", "hygf_07", "法务审核"),
    SJSCDXTK(1009, "待设计上传典型图库", "hygf_09", "设计上传典型图库"),
    JXSSJRYSC(1010, "待经销商设计人员上传设计图", "hygf_10", "经销商设计人员上传设计图"),
    SJTZSH(1011, "待设计图纸审核", "hygf_11", "设计图纸审核"),
    BWDJTJ(1012, "待并网登记提交", "hygf_bw1", "并网登记提交"),
    BWGLDGCSH(1013, "待并网管理端工程审核", "hygf_bw2", "并网管理端工程审核"),
    JXSGCTJYS(1014, "待经销商工程提交验收", "hygf_ys1", "经销商工程提交验收"),
    GLDTRSH(1015, "待管理端投融审核", "hygf_ys2", "管理端投融审核"),
    ZGD(1016, "待整改单", "hygf_zg_tr", "整改单"),
    GLDFWSH(1017, "待管理端法务审核", "hygf_ys3", "管理端法务审核"),
    ZGD_FW(1018, "待整改单", "hygf_zg_fw", "整改单"),
    GLDGCSH(1019, "待管理端工程审核", "hygf_ys4", "管理端工程审核"),
    ZGD_GC(1020, "待整改单", "hygf_zg_gc", "整改单"),
    GLDGCYX(1021, "待管理端工程是否线下", "hygf_ys5", "管理端工程是否线下"),
    GLDGCXY(1022, "待管理端工程线下验", "hygf_ys6", "管理端工程线下验"),
    ZGD_XX(1023, "待整改单", "hygf_zg_xx", "整改单"),
    ;

    private final int code;

    private final String dealName;
    private final String flowNodeKey;
    private final String flowNodeName;


    public static FlowKeyTodoEnum getEumByFlowNodeKey(String flowNodeKey) {
        for (FlowKeyTodoEnum statusEnum : FlowKeyTodoEnum.values()) {
            if (statusEnum.getFlowNodeKey().equals(flowNodeKey)) {
                return statusEnum;
            }
        }
        return null;
    }

}