package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 农户认证状态
 *
 * @author Provence
 * @version v1.0
 * @date 2023/8/25 10:17
 */
@Getter
@AllArgsConstructor
public enum PeasantHouseholdEnum {

    未认证("未认证", 0),
    已认证("已认证", 1);


    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private int code;

    public static PeasantHouseholdEnum getNodeByCode(int code) {
        PeasantHouseholdEnum peasantHouseholdEnum = null;
        for (PeasantHouseholdEnum type : PeasantHouseholdEnum.values()) {
            if (type.getCode() == code) {
                peasantHouseholdEnum = type;
                break;
            }
        }
        return peasantHouseholdEnum;
    }
}
