package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 验收状态枚举
 */
@Getter
@AllArgsConstructor
@SuppressWarnings("ALL")
public enum PowerStationEnum {

    经销商确认("经销商确认", "1","hygf_02",""),

    设计审核("设计审核", "2", "hygf_03","hygf/Sjsh"),

    投融审核("投融审核", "3", "hygf_05","hygf/Sjsh"),

    法务审核("法务审核", "4","hygf_07","hygf/Sjsh"),

    设计上传典型图纸("设计上传典型图纸", "5", "hygf_09","hygf/Trsh"),

    经销商设计上传设计图纸("经销商设计上传设计图纸", "6", "hygf_10","hygf/Fwsh"),

    设计图纸审核("设计图纸审核", "7", "hygf_11","hygf/Sjsh"),

    完成("完成", "11", "hygf_13","");

    /**
     * 名称，描述
     */
    private final String name;
    /**
     * 编码
     */
    private final String code;

    //节点key
    private final String key;

    //路由r
    private final String routing;


    public static PowerStationEnum getNodeByCode(String code) {
        PowerStationEnum acceptanceStatusEnum = null;
        for (PowerStationEnum type : PowerStationEnum.values()) {
            if (code.equals(type.getCode())) {
                acceptanceStatusEnum = type;
                break;
            }
        }
        return acceptanceStatusEnum;
    }
    public static String getNodeByKey(String Key) {
        PowerStationEnum acceptanceStatusEnum = null;
        for (PowerStationEnum type : PowerStationEnum.values()) {
            if (type.getKey().contains(Key)) {
                acceptanceStatusEnum = type;
                break;
            }
        }
        return acceptanceStatusEnum.getRouting();
    }
}
