package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 电站审核状态
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum PowerStationProcessStateEnum {
    进行中("进行中", "0", "progress"),
    设计待审核("设计待审核", "5", "design"),
    投融待审核("投融待审核", "6", "tourong"),
    法务待审核("法务待审核", "7", "fawu"),
    典设图纸待上传("典设图纸待上传", "8", "dst"),
    施工图纸待上传("施工图纸待上传", "9", "sgt"),
    图纸待审校("图纸待审校", "10", "tzdsj"),
    通过("通过", "1", "0"),
    不通过("不通过", "2", "1"),
    完成("完成", "3", "complete"),
    作废("作废", "4", "reject");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 编码
     */
    private String describe;

    public static PowerStationProcessStateEnum getStateByResult(String code) {
        PowerStationProcessStateEnum powerStationProcessStateEnum = null;
        for(PowerStationProcessStateEnum type: PowerStationProcessStateEnum.values()) {
            if (type.getDescribe().equals(code)) {
                powerStationProcessStateEnum = type;
                break;
            }
        }
        return powerStationProcessStateEnum;
    }

}
