package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.support.spring.annotation.FastJsonFilter;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2024-04-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FinancingInfoDto", description = "")
public class FinancingInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "所属融资公司id",example = "1844212763006627841")
    private Long financingCompaniesSeq;

    @ApiModelProperty(value = "所属融资公司名称",example = "江苏金融租赁股份有限公司")
    private String financingCompaniesName;

    @ApiModelProperty(value = "所属融资公司code",example = "86*355*714*908")
    private String financingCompaniesCode;

    @ApiModelProperty(value = "农户id",example = "1826216671409369089")
    private Long peasantHouseholdId;

    @ApiModelProperty(value = "区域公司Id",example = "1703949560172277762")
    private Long regionalCompaniesSeq;

    @ApiModelProperty(value = "放款时间",example = "2024-04-11")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date disbursementTime;

    @ApiModelProperty(value = "元",example ="500")
    private Double disbursementMoney;

    @ApiModelProperty(value = "附件")
    private String file;

    @ApiModelProperty(value = "状态",example = "待推送")
    private String status;

    @ApiModelProperty(value = "批量推送时使用",example = "[1703949560172277762,1703949560172277762,1703949560172277762]")
    private String peasantHouseholdIds;

    @ApiModelProperty(value = "工作流示例id",example ="187314")
    private String instanceId;


    @ApiModelProperty(value = "批次号",example = "1729584315664")
    private String batchNo;

    @ApiModelProperty(value = "附件")
    private List<Object> files;

    @ApiModelProperty(value = "单价",example = "0.65")
    private String unitPrice;
    @ApiModelProperty(value = "投融创建时间",example = "2024-11-19")
    private Date trCreateTime;
    @ApiModelProperty(value = "批量放款录入使用",example = "[1703949560172277762,1703949560172277762,1703949560172277762]")
    List<PeasantHousehold> peasantHouseholds;
}
