package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 异常日志
 *
 * @author hzz
 * @date 2025-03-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_exception_log")
@ApiModel(value="ExceptionLog", description="异常日志")
public class ExceptionLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 请求信息
     */
    @ApiModelProperty(value = "请求信息")
	@TableField("request")
    private String request;

    /**
     * 请求体
     */
    @ApiModelProperty(value = "请求体")
    @TableField("req_body")
    private String reqBody;

    /**
     * 错误日志
     */
    @ApiModelProperty(value = "错误日志")
	@TableField("error_log")
    private Object errorLog;

    /**
     * 制单日期
     */
    @ApiModelProperty(value = "业务类型")
	@TableField("business_type")
    private String businessType;

}
