package com.yeejoin.amos.boot.module.hygf.api.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.util.Date;

import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * (hygf_icbc_record)实体类
 *
 * @author yangyang
 * @description
 * @since 2024-07-18 11:40:46
 */
@Data
@NoArgsConstructor
@Accessors (chain = true)
@TableName (value = "hygf_icbc_record", autoResultMap = true)
public class HygfIcbcRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 农户姓名
     */
    @TableField ("cust_name")
    private String custName;
    /**
     * 身份证号
     */
    @TableField ("id_card")
    private String idCard;
    /**
     * 手机号码
     */
    @TableField ("phone")
    private String phone;
    /**
     * 聚富通电子账户账号
     */
    @TableField ("medium_id")
    private String mediumId;
    /**
     * 项目编号
     */
    @TableField ("project_id")
    private String projectId;
    /**
     * 开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败
     */
    @TableField ("open_account_status")
    private String openAccountStatus;
    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @TableField ("protocol_status")
    private String protocolStatus;
    /**
     * 协议开始日期
     */
    @TableField ("protocol_start_time")
    private String protocolStartTime;
    /**
     * 协议终止日期
     */
    @TableField ("protocol_end_time")
    private String protocolEndTime;
    /**
     * 单笔限额
     */
    @TableField ("trx_limit_amount")
    private String trxLimitAmount;
    /**
     * 日累计限额
     */
    @TableField ("day_limit_amount")
    private String dayLimitAmount;
    /**
     * 协议总限额
     */
    @TableField ("protocol_limit_amount")
    private String protocolLimitAmount;
    /**
     * 合作方 appid
     */
    @TableField ("app_id")
    private String appId;
    /**
     * 外部用户编号
     */
    @TableField ("out_user_id")
    private String outUserId;
    /**
     * 企业外系统编号
     */
    @TableField ("out_vendor_id")
    private String outVendorId;
    /**
     * signEntrsutPrtlStatus
     */
    @TableField ("sign_entrsut_prtl_status")
    private String signEntrsutPrtlStatus;
    /**
     * 作废申请状态
     */
    @TableField ("discard_status")
    private String discardStatus;
    /**
     * 农户 用户 id
     */
    @TableField("amos_user_id")
    private String amosUserId;

    @TableField("type")
    private String type;
}