package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkOrderPage;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.entity.WorkOrder;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 施工派工工单 Mapper 接口
 *
 * @author system_generator
 * @date 2024-01-02
 */
public interface WorkOrderMapper extends BaseMapper<WorkOrder> {
    @UserEmpower(field = {}, dealerField = {"hygf_work_order.amos_dealer_org_code","hygf_work_order.region_code"}, fieldConditions = {"eq", "in", }, relationship = "and")
    List<WorkOrder> selectWorkOrderList(@Param("dto") WorkOrder dto);
    @UserEmpower(field = {"region_code"}, dealerField = {"hygf_work_order.amos_dealer_org_code","hygf_work_order.region_code","hygf_peasant_household.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    List<WorkOrderPage> queryForwgpage(@Param("dto") WorkOrderPage dto);

    String getRealNameByUserId(String userId);
}
