package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.ConstructionAcceptanceRecordsServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.ConstructionAcceptanceRecordsDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 并网操作日志
 *
 * @author system_generator
 * @date 2024-09-02
 */
@RestController
@Api(tags = "并网操作日志Api")
@RequestMapping(value = "/construction-acceptance-records")
public class ConstructionAcceptanceRecordsController extends BaseController {

    @Autowired
    ConstructionAcceptanceRecordsServiceImpl constructionAcceptanceRecordsServiceImpl;

    /**
     * 新增并网操作日志
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增并网操作日志", notes = "新增并网操作日志")
	public ResponseModel<ConstructionAcceptanceRecordsDto> save(@RequestBody ConstructionAcceptanceRecordsDto model) {
	    model = constructionAcceptanceRecordsServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新并网操作日志", notes = "根据sequenceNbr更新并网操作日志")
	public ResponseModel<ConstructionAcceptanceRecordsDto> updateBySequenceNbrConstructionAcceptanceRecords(@RequestBody ConstructionAcceptanceRecordsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(constructionAcceptanceRecordsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除并网操作日志", notes = "根据sequenceNbr删除并网操作日志")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(constructionAcceptanceRecordsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网操作日志",  notes = "根据sequenceNbr查询单个并网操作日志")
	public ResponseModel<ConstructionAcceptanceRecordsDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(constructionAcceptanceRecordsServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "并网操作日志分页查询",  notes = "并网操作日志分页查询")
	public ResponseModel<Page<ConstructionAcceptanceRecordsDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<ConstructionAcceptanceRecordsDto> page = new Page<ConstructionAcceptanceRecordsDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(constructionAcceptanceRecordsServiceImpl.queryForConstructionAcceptanceRecordsPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "并网操作日志列表全部数据查询",   notes = "并网操作日志列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ConstructionAcceptanceRecordsDto>> selectForList() {
	    return ResponseHelper.buildResponse(constructionAcceptanceRecordsServiceImpl.queryForConstructionAcceptanceRecordsList());
	}
}
