package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.IdsDTO;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingInfoHistory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingInfoHistoryServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoHistoryDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 投融信息
 *
 * @author system_generator
 * @date 2024-10-22
 */
@RestController
@Api(tags = "投融信息Api")
@RequestMapping(value = "/financing-info-history")
public class FinancingInfoHistoryController extends BaseController {

    @Autowired
    FinancingInfoHistoryServiceImpl financingInfoHistoryServiceImpl;

    /**
     * 新增投融信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增投融信息", notes = "新增投融信息")
	public ResponseModel<FinancingInfoHistoryDto> save(@RequestBody FinancingInfoHistoryDto model) {
	    model = financingInfoHistoryServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新投融信息", notes = "根据sequenceNbr更新投融信息")
	public ResponseModel<FinancingInfoHistoryDto> updateBySequenceNbrFinancingInfoHistory(@RequestBody FinancingInfoHistoryDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(financingInfoHistoryServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除投融信息", notes = "根据sequenceNbr删除投融信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(financingInfoHistoryServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个投融信息",  notes = "根据sequenceNbr查询单个投融信息")
	public ResponseModel<FinancingInfoHistoryDto> selectOne(@PathVariable Long sequenceNbr) {

	    return ResponseHelper.buildResponse(financingInfoHistoryServiceImpl.getDataInfo(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "投融信息分页查询",  notes = "投融信息分页查询")
	public ResponseModel<Page<Map<String, Object>>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size,@RequestParam(value = "ownersName",required = false) String ownersName , @RequestParam(value = "status",required = false) String status, @RequestParam(value = "province",required = false) String province) {
		List<String> statusList = new ArrayList<>();
		if (null != status ){
			statusList = Arrays.asList(status.split(","));
		}
	    return ResponseHelper.buildResponse(financingInfoHistoryServiceImpl.queryForFinancingInfoHistoryPage(current,size,ownersName,statusList,province));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "投融信息列表全部数据查询",   notes = "投融信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FinancingInfoHistoryDto>> selectForList() {
	    return ResponseHelper.buildResponse(financingInfoHistoryServiceImpl.queryForFinancingInfoHistoryList());
	}
	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateMoney")
	@ApiOperation(httpMethod = "PUT", value = "批量放款录入", notes = "批量放款录入")
	@Transactional
	public ResponseModel<FinancingInfoHistoryDto> updateMoney(@RequestBody FinancingInfoHistoryDto financingInfoDto) {


		financingInfoHistoryServiceImpl.upDateMoney(financingInfoDto);

		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 新增
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateState")
	@ApiOperation(httpMethod = "PUT", value = "新增", notes = "新增")
	@Transactional
	public ResponseModel updateState(@RequestBody IdsDTO ids) {
		financingInfoHistoryServiceImpl.updateState(ids.getIds());
		return ResponseHelper.buildResponse(null);
	}

}
