package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingRegional;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Arrays;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingRegionalServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingRegionalDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 融资机构区域公司绑定表
 *
 * @author system_generator
 * @date 2024-09-19
 */
@RestController
@Api(tags = "融资机构区域公司绑定表Api")
@RequestMapping(value = "/financing-regional")
public class FinancingRegionalController extends BaseController {

    @Autowired
    FinancingRegionalServiceImpl financingRegionalServiceImpl;

    /**
     * 新增融资机构区域公司绑定表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增融资机构区域公司绑定表", notes = "新增融资机构区域公司绑定表")
	public ResponseModel<FinancingRegionalDto> save(@RequestBody FinancingRegionalDto model) {


		financingRegionalServiceImpl.saveModel(model);
	    return ResponseHelper.buildResponse(null);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新融资机构区域公司绑定表", notes = "根据sequenceNbr更新融资机构区域公司绑定表")
	public ResponseModel<FinancingRegionalDto> updateBySequenceNbrFinancingRegional(@RequestBody FinancingRegionalDto model) {
		financingRegionalServiceImpl.updateModel(model);
	    return ResponseHelper.buildResponse(null);
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除融资机构区域公司绑定表", notes = "根据sequenceNbr删除融资机构区域公司绑定表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){

		financingRegionalServiceImpl.removeModel(sequenceNbr);

        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个融资机构区域公司绑定表",  notes = "根据sequenceNbr查询单个融资机构区域公司绑定表")
	public ResponseModel<FinancingRegionalDto> selectOne(@PathVariable Long sequenceNbr) {
		FinancingRegionalDto financingRegionalDto = financingRegionalServiceImpl.queryBySeq(sequenceNbr);
		financingRegionalDto.setFinancing(Arrays.asList(financingRegionalDto.getFinancingId().split(",")));
		financingRegionalDto.setRegionalCompanies(Arrays.asList(financingRegionalDto.getRegionalCompaniesSeq().split(",")));
		return ResponseHelper.buildResponse(financingRegionalDto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "融资机构区域公司绑定表分页查询",  notes = "融资机构区域公司绑定表分页查询")
	@UserLimits
	public ResponseModel<Page<FinancingRegional>> queryForPage(@RequestParam(value = "current") int current,
															   @RequestParam(value = "size") int size,
															   @RequestParam(value = "regionalCompaniesName",required = false) String regionalCompaniesName,
															   @RequestParam(value = "province",required = false) String province

	) {

	    return ResponseHelper.buildResponse(financingRegionalServiceImpl.queryForFinancingRegionalPage(current,size,regionalCompaniesName,province));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "融资机构区域公司绑定表列表全部数据查询",   notes = "融资机构区域公司绑定表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FinancingRegionalDto>> selectForList() {
	    return ResponseHelper.buildResponse(financingRegionalServiceImpl.queryForFinancingRegionalList());
	}
}
