package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfOnGridDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfOnGrid;
import com.yeejoin.amos.boot.module.hygf.api.mapper.HygfOnGridMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HygfOnGridServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 并网信息
 *
 * @author system_generator
 * @date 2024-01-12
 */
@RestController
@Api(tags = "并网信息Api")
@RequestMapping(value = "/hygf-on-grid")
public class HygfOnGridController extends BaseController {

    @Autowired
    HygfOnGridServiceImpl hygfOnGridServiceImpl;
    @Autowired
    HygfOnGridMapper hygfOnGridMapper;
    /**
     * 新增并网信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增并网信息", notes = "新增并网信息")
	public ResponseModel<HygfOnGridDto> save(@RequestBody HygfOnGridDto model) {
	    model = hygfOnGridServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新并网信息", notes = "根据sequenceNbr更新并网信息")
	public ResponseModel<HygfOnGridDto> updateBySequenceNbrHygfOnGrid(@RequestBody HygfOnGridDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(hygfOnGridServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除并网信息", notes = "根据sequenceNbr删除并网信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(hygfOnGridServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网信息",  notes = "根据sequenceNbr查询单个并网信息")
	public ResponseModel<HygfOnGridDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(hygfOnGridServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "并网信息分页查询",  notes = "并网信息分页查询")
	public ResponseModel<Page<HygfOnGridDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<HygfOnGridDto> page = new Page<HygfOnGridDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(hygfOnGridServiceImpl.queryForHygfOnGridPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "并网信息列表全部数据查询",   notes = "并网信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HygfOnGridDto>> selectForList() {
	    return ResponseHelper.buildResponse(hygfOnGridServiceImpl.queryForHygfOnGridList());
	}



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getHygfOnGridbyid")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网信息",  notes = "根据sequenceNbr查询单个并网信息")
    public ResponseModel<HygfOnGrid> getHygfOnGridbyid(@RequestParam(required = false) Long sequenceNbr) {
        HygfOnGrid da=new HygfOnGrid();
	    if(sequenceNbr!=null){
            da=  hygfOnGridMapper.selectById(sequenceNbr);
        }
        return ResponseHelper.buildResponse(da);
    }

}
