package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RectificationOrderEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RectificationRoleEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.WorkOrderEnum;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfRectificationOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HygfRectificationOrderServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfRectificationOrderDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 审核单
 *
 * @author system_generator
 * @date 2024-08-12
 */
@RestController
@Api(tags = "审核单Api")
@RequestMapping(value = "/hygf-rectification-order")
public class HygfRectificationOrderController extends BaseController {

    @Autowired
    HygfRectificationOrderServiceImpl hygfRectificationOrderServiceImpl;
	@Value("${admin.engineering.roleId}")
	Long engineeringId;
	@Value("${admin.area.roleId}")
	Long areaId;
	@Value("${admin.design.roleId}")
	Long designId;
	@Value("${admin.deveEngineering.roleId}")
	Long deveEngineeringId;
	@Value("${admin.delerAdmin.roleId}")
	Long delerAdminId;
	@Value("${admin.delerKaId.roleId}")
	Long delerKfId;
	@Value("${admin.tourong.roleId}")
	Long tourongId;
	@Value("${admin.fawu.roleId}")
	Long fawuId;
	@Value("${admin.zichan.roleId}")
	Long zichanId;
    /**
     * 新增审核单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增审核单", notes = "新增审核单")
	public ResponseModel<HygfRectificationOrderDto> save(@RequestBody HygfRectificationOrderDto model) {
		model = hygfRectificationOrderServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新审核单", notes = "根据sequenceNbr更新审核单")
	public ResponseModel<HygfRectificationOrderDto> updateBySequenceNbrHygfRectificationOrder(@RequestBody HygfRectificationOrderDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除审核单", notes = "根据sequenceNbr删除审核单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个审核单",  notes = "根据sequenceNbr查询单个审核单")
	public ResponseModel<HygfRectificationOrder> selectOne(@PathVariable Long sequenceNbr) {
		HygfRectificationOrder hygfRectificationOrder = hygfRectificationOrderServiceImpl.getBaseMapper().selectById(sequenceNbr);
		RectificationRoleEnum enums = RectificationRoleEnum.getNodeByName(hygfRectificationOrder.getRectificationSource());
		hygfRectificationOrder.setRectificationSourceName(enums!=null?enums.name():null);
		return ResponseHelper.buildResponse(hygfRectificationOrder);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "审核单分页查询",  notes = "审核单分页查询")
	public ResponseModel<Page<HygfRectificationOrder>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size, @RequestParam(value = "rectificationSource",required = false) String rectificationSource, @RequestParam(value = "peasantHouseholeId") String peasantHouseholeId) {

		ReginParams reginParams = getSelectedOrgInfo();
		List<String> workOrderPowerStationNodes = new ArrayList<>();
		List<String> status = new ArrayList<>();
//		workOrderPowerStationNodes.add(rectificationSource);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			if (longs.contains(areaId) ) {
				workOrderPowerStationNodes.add("area");
			}
			if (longs.contains(engineeringId) ) {
				workOrderPowerStationNodes.add("engineering");
			}
			if (longs.contains(designId) ) {
				workOrderPowerStationNodes.add("design");
			}
			if (longs.contains(delerAdminId) ) {
				workOrderPowerStationNodes.add("design");
				workOrderPowerStationNodes.add("engineering");
				workOrderPowerStationNodes.add("area");
			}
		}

		Page<HygfRectificationOrder> page = hygfRectificationOrderServiceImpl.queryForHygfRectificationOrderPage(current, size, workOrderPowerStationNodes, peasantHouseholeId,status);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			page.getRecords().forEach(e->{
				if(e.getRectificationIdea() != null && e.getRectificationIdea().size() > 0) {
					List<String> types = new ArrayList<>();
					e.getRectificationIdea().forEach(t -> {
						JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(t));
						if(jsonObject.getString("type") != null) {
							types.add(jsonObject.getString("type"));
						}
					});
					e.setRectificationType(String.join(",", types));
				}


				if (longs.contains(areaId) && e.getRectificationSource().equals("area")){
					e.setIsAudit("0");
				}else if (longs.contains(engineeringId) && e.getRectificationSource().equals("engineering")){
					e.setIsAudit("0");
				}else if (longs.contains(designId) && e.getRectificationSource().equals("design")){
					e.setIsAudit("0");
				}else if (longs.contains(deveEngineeringId)&& (e.getRectificationStatus().equals("待审核") || e.getRectificationStatus().equals("整改中"))){
					e.setIsAudit("0");
				}else {
					e.setIsAudit("1");
				}
			});
		}

		return ResponseHelper.buildResponse(page);
	}


	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/bwpage")
	@ApiOperation(httpMethod = "GET",value = "审核单分页查询 并网",  notes = "审核单分页查询 并网")
	public ResponseModel<Page<HygfRectificationOrder>> queryForPageBybw(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, @RequestParam(value = "rectificationSource",required = false) String rectificationSource, @RequestParam(value = "peasantHouseholeId") String peasantHouseholeId) {

		ReginParams reginParams = getSelectedOrgInfo();
		List<String> workOrderPowerStationNodes = new ArrayList<>();
		List<String> status = new ArrayList<>();
//		workOrderPowerStationNodes.add(rectificationSource);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			if (longs.contains(areaId) ) {
				workOrderPowerStationNodes.add("bw-area");
			}
			if (longs.contains(engineeringId) ) {
				workOrderPowerStationNodes.add("bw-engineering");
			}
			if (longs.contains(designId) ) {
				workOrderPowerStationNodes.add("bw-design");
			}
			if (longs.contains(delerAdminId) ) {
				workOrderPowerStationNodes.add("bw-design");
				workOrderPowerStationNodes.add("bw-engineering");
				workOrderPowerStationNodes.add("bw-area");
				status.add(WorkOrderEnum.待整改.name());
				status.add(WorkOrderEnum.整改中.name());
				status.add(WorkOrderEnum.待审核.name());
				status.add(WorkOrderEnum.已完成.name());
			}if (longs.contains(delerKfId) ) {
				workOrderPowerStationNodes.add("bw-design");
				workOrderPowerStationNodes.add("bw-engineering");
				workOrderPowerStationNodes.add("bw-area");
				status.add(WorkOrderEnum.待整改.name());
				status.add(WorkOrderEnum.整改中.name());
				status.add(WorkOrderEnum.待审核.name());
				status.add(WorkOrderEnum.已完成.name());
			}
		}

		Page<HygfRectificationOrder> page = hygfRectificationOrderServiceImpl.queryForHygfRectificationOrderPage(current, size, workOrderPowerStationNodes, peasantHouseholeId,status);


		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			page.getRecords().forEach(e->{
				if(e.getRectificationIdea() != null && e.getRectificationIdea().size() > 0) {
					List<String> types = new ArrayList<>();
					e.getRectificationIdea().forEach(t -> {
						JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(t));
						if(jsonObject.getString("type") != null) {
							types.add(jsonObject.getString("type"));
						}
					});
					e.setRectificationType(String.join(",", types));
				}


				if (longs.contains(areaId) && e.getRectificationSource().equals("bw-area") &&rectificationSource.contains(e.getRectificationSource())){
					e.setIsAudit("0");
				}else if (longs.contains(engineeringId) && e.getRectificationSource().equals("bw-engineering")&& rectificationSource.contains(e.getRectificationSource())){
					e.setIsAudit("0");
				}else if (longs.contains(designId) && e.getRectificationSource().equals("bw-design")&& rectificationSource.contains(e.getRectificationSource())){
					e.setIsAudit("0");
				}else if (longs.contains(delerKfId)&& (e.getRectificationStatus().equals("待整改") || e.getRectificationStatus().equals("整改中"))){
					e.setIsAudit("0");
				}else {
					e.setIsAudit("1");
				}
			});
		}

		return ResponseHelper.buildResponse(page);
	}


	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/yspage")
	@ApiOperation(httpMethod = "GET",value = "审核单分页查询 验收",  notes = "审核单分页查询 验收")
	public ResponseModel<Page<HygfRectificationOrder>> queryForPageByYs(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, @RequestParam(value = "rectificationSource",required = false) String rectificationSource, @RequestParam(value = "peasantHouseholeId") String peasantHouseholeId) {

		ReginParams reginParams = getSelectedOrgInfo();
		List<String> workOrderPowerStationNodes = new ArrayList<>();
		List<String> status = new ArrayList<>();
//		workOrderPowerStationNodes.add(rectificationSource);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			if (longs.contains(areaId) ) {
				workOrderPowerStationNodes.add("ys-area");
			}
			if (longs.contains(tourongId) ) {
				workOrderPowerStationNodes.add("ys-tourong");
			}
			if (longs.contains(fawuId) ) {
				workOrderPowerStationNodes.add("ys-fawu");
			}
			if (longs.contains(zichanId) ) {
				workOrderPowerStationNodes.add("ys-zichan");
			}
			if (longs.contains(delerAdminId) ) {
				workOrderPowerStationNodes.add("ys-zichan");
				workOrderPowerStationNodes.add("ys-tourong");
				workOrderPowerStationNodes.add("ys-fawu");
				workOrderPowerStationNodes.add("ys-area");
				status.add(WorkOrderEnum.待整改.name());
				status.add(WorkOrderEnum.整改中.name());
				status.add(WorkOrderEnum.待审核.name());
				status.add(WorkOrderEnum.已完成.name());
			}if (longs.contains(deveEngineeringId) ) {
				workOrderPowerStationNodes.add("ys-zichan");
				workOrderPowerStationNodes.add("ys-tourong");
				workOrderPowerStationNodes.add("ys-fawu");
				workOrderPowerStationNodes.add("ys-area");
				status.add(WorkOrderEnum.待整改.name());
				status.add(WorkOrderEnum.整改中.name());
				status.add(WorkOrderEnum.待审核.name());
				status.add(WorkOrderEnum.已完成.name());
			}
//			if (longs.contains(delergcId) ) {
//				workOrderPowerStationNodes.add("ys-design");
//				workOrderPowerStationNodes.add("ys-engineering");
//				workOrderPowerStationNodes.add("ys-area");
//			}
		}
		Page<HygfRectificationOrder> page = hygfRectificationOrderServiceImpl.queryForHygfRectificationOrderPage(current, size, workOrderPowerStationNodes, peasantHouseholeId,status);
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			page.getRecords().forEach(e->{
				if(e.getRectificationIdea() != null && e.getRectificationIdea().size() > 0) {
					List<String> types = new ArrayList<>();
					e.getRectificationIdea().forEach(t -> {
						JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(t));
						if(jsonObject.getString("type") != null) {
							types.add(jsonObject.getString("type"));
						}
					});
					e.setRectificationType(String.join(",", types));
				}


				if (longs.contains(areaId) && e.getRectificationSource().equals("ys-area") && rectificationSource.contains(e.getRectificationSource()) ){
					e.setIsAudit("0");
				}else if (longs.contains(tourongId) && e.getRectificationSource().equals("ys-tourong")&& rectificationSource.contains(e.getRectificationSource())){
					e.setIsAudit("0");
				}else if (longs.contains(fawuId) && e.getRectificationSource().equals("ys-fawu")&& rectificationSource.contains(e.getRectificationSource())){
					e.setIsAudit("0");
				}else if (longs.contains(zichanId) && e.getRectificationSource().equals("ys-zichan")&& rectificationSource.contains(e.getRectificationSource())){
					e.setIsAudit("0");
				}else if (longs.contains(deveEngineeringId) && (e.getRectificationStatus().equals("待审核") || e.getRectificationStatus().equals("整改中"))){
					e.setIsAudit("0");
				}else {
					e.setIsAudit("1");
				}
			});
		}

		return ResponseHelper.buildResponse(page);
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "审核单列表全部数据查询",   notes = "审核单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HygfRectificationOrder>> selectForList(@RequestParam(value = "peasantHouseholeId") String peasantHouseholeId,@RequestParam(value = "sourceType") String sourceType) {

		return ResponseHelper.buildResponse(hygfRectificationOrderServiceImpl.selectForListBySource(peasantHouseholeId,sourceType));
	}
}
